/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;

public class WorkspacesInstaller {
    WorkspacesManager workspacesManager = null;
    private IProgressMonitor progressMonitor;
    private WorkspaceModel wsToRemove;

    public WorkspacesInstaller(WorkspacesManager workspacesManager) {
        this.workspacesManager = workspacesManager;
    }

    public String deployWorkspace(File wsZipFile) throws Exception {
        File wsRootDir = this.createNewWorkspaceDir();
        String res = CoreUtils.unzipFileWithProgressDescriptor(wsRootDir, wsZipFile, this.progressMonitor, "Workspace installation");
        if (this.wsToRemove != null) {
            this.removeWorkspace(this.wsToRemove);
            this.wsToRemove = null;
        }
        this.workspacesManager.rebuildWsRegistry();
        return res;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public static String validateWorkspaceFile(File wsZipFile) throws Exception {
        if (wsZipFile == null) {
            throw new Exception("Empty or null zip file");
        }
        HashMap<String, ZipEntry> wsFileRegistry = new HashMap<String, ZipEntry>(10);
        ByteArrayOutputStream outstream = null;
        ZipInputStream zinstream = new ZipInputStream(new FileInputStream(wsZipFile));
        String res = null;
        ZipEntry zentry = zinstream.getNextEntry();
        while (zentry != null) {
            String entryName = zentry.getName();
            if (entryName.equals("ws.xml") || entryName.equals("ws2.xml")) {
                int n;
                byte[] buf = new byte[1024];
                outstream = new ByteArrayOutputStream();
                while ((n = zinstream.read(buf, 0, 1024)) > -1) {
                    outstream.write(buf, 0, n);
                }
                res = outstream.toString("UTF-8");
                outstream.close();
            }
            if (!entryName.endsWith(".dat")) {
                wsFileRegistry.put(entryName, zentry);
            }
            zinstream.closeEntry();
            zentry = zinstream.getNextEntry();
        }
        zinstream.close();
        if (!wsFileRegistry.containsKey("ws2.xml") && !wsFileRegistry.containsKey("ws.xml")) {
            throw new Exception("The zip file does not contain ws2.xml file");
        }
        if (!wsFileRegistry.containsKey("db/") && !wsFileRegistry.containsKey("db\\")) {
            throw new Exception("The zip file does not contain db folder");
        }
        if (!wsFileRegistry.containsKey("jar/") && !wsFileRegistry.containsKey("jar\\")) {
            throw new Exception("The zip file does not contain jar folder");
        }
        if (!wsFileRegistry.containsKey("jar\\fishstatj-jdbc-dao.jar") && !wsFileRegistry.containsKey("jar/fishstatj-jdbc-dao.jar")) {
            throw new Exception("The zip file does not contain fishstatj-jdbc-dao.jar file");
        }
        return res;
    }

    private File createNewWorkspaceDir() {
        String wsID = this.findNewWorkspaceId();
        File wsRootDir = new File(String.valueOf(this.workspacesManager.getRoot().getAbsolutePath()) + File.separator + wsID);
        boolean created = wsRootDir.mkdirs();
        if (created) {
            System.out.println("[  OK  ]");
            File wsPropertiesDir = new File(wsRootDir, "properties");
            wsPropertiesDir.mkdir();
            File wsSessionDir = new File(wsRootDir, "session");
            wsSessionDir.mkdir();
        } else {
            System.out.println("[FAILED]");
        }
        return wsRootDir;
    }

    private String findNewWorkspaceId() {
        int i = 0;
        while (i < 10000) {
            boolean found = false;
            String candidateId = "ws_" + CoreUtils.getTextualNumber(i, '0', 4);
            String[] dirResult = this.workspacesManager.getRoot().list();
            if (dirResult == null) {
                return candidateId;
            }
            String[] stringArray = dirResult;
            int n = dirResult.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (candidateId.equals(string)) {
                    found = true;
                }
                ++n2;
            }
            if (!found) {
                return candidateId;
            }
            ++i;
        }
        return null;
    }

    public void setWsToRemove(WorkspaceModel wsToRemove) {
        this.wsToRemove = wsToRemove;
    }

    public void removeWorkspace(WorkspaceModel workspace) {
        File wsFile;
        if (!this.workspacesManager.isValidWorkspace(workspace)) {
            return;
        }
        if (workspace.equals(this.workspacesManager.getCurrentWorkspace())) {
            this.workspacesManager.closeCurrentWorkspace();
        }
        if ((wsFile = new File(workspace.getWsBaseDir(), "ws.xml")).exists()) {
            wsFile.delete();
            this.workspacesManager.rebuildWsRegistry();
            CoreUtils.removeDirectory(workspace.getWsBaseDir());
        }
        if ((wsFile = new File(workspace.getWsBaseDir(), "ws2.xml")).exists()) {
            wsFile.delete();
            this.workspacesManager.rebuildWsRegistry();
            CoreUtils.removeDirectory(workspace.getWsBaseDir());
        }
    }
}

