/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.management.test;

import java.util.Date;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.TimeseriesDescriptor;
import org.junit.BeforeClass;
import org.junit.Test;

public class TradeTimeseriesManagementTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    private void fire() throws Exception {
        System.out.println("firing changes...");
        Commons.fire();
        System.out.println("changes fired.");
    }

    @Test
    public void testCreateValueTimeseries() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TRADE");
        Timeseries timeseries = dataset.getTimeseries("VALUE");
        if (timeseries != null) {
            System.out.println("removing VALUE timeseries...");
            TimeseriesManagementServiceFactory.getService().removeTimeseries(timeseries);
            System.out.println("VALUE timeseries removed");
        }
        MultilingualString name = new MultilingualString();
        name.setValue("en", "Value");
        MultilingualString description = new MultilingualString();
        description.setValue("en", "Global commodities trade value");
        TimeseriesDescriptor descriptor = DescriptorsFactory.createTimeseriesDescriptor(dataset, DataSource.FAO, "VALUE", name, description, TimeResolution.YEAR, new ObservationPeriod("Y1976"), new ObservationPeriod("Y2006"), null, new Version("1.0", new Date(), "F.Calderini"));
        System.out.println("recreating VALUE timeseries...");
        timeseries = TimeseriesManagementServiceFactory.getService().createTimeseries(descriptor);
        this.fire();
        System.out.println("VALUE timeseries created: " + timeseries);
    }

    @Test
    public void testCreateQuantityTimeseries() throws Exception {
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset("TRADE");
        Timeseries timeseries = dataset.getTimeseries("QUANTITY");
        if (timeseries != null) {
            System.out.println("removing QUANTITY timeseries...");
            TimeseriesManagementServiceFactory.getService().removeTimeseries(timeseries);
            System.out.println("QUANTITY timeseries removed");
        }
        MultilingualString name = new MultilingualString();
        name.setValue("en", "Quantity");
        MultilingualString description = new MultilingualString();
        description.setValue("en", "Global commodities production and trade quantity");
        TimeseriesDescriptor descriptor = DescriptorsFactory.createTimeseriesDescriptor(dataset, DataSource.FAO, "QUANTITY", name, description, TimeResolution.YEAR, new ObservationPeriod("Y1976"), new ObservationPeriod("Y2006"), null, new Version("1.0", new Date(), "F.Calderini"));
        System.out.println("recreating QUANTITY timeseries...");
        timeseries = TimeseriesManagementServiceFactory.getService().createTimeseries(descriptor);
        this.fire();
        System.out.println("QUANTITY timeseries created: " + timeseries);
    }
}

