/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.filter;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.IReferenceObjectProcessor;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.ParentRelationSelection;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.composites.ParentSelector;
import org.fao.fi.fishstat.gui.components.composites.ReferenceList;
import org.fao.fi.fishstat.gui.components.menus.MenusUtils;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.filter.KeyFilterContentProvider;
import org.fao.fi.fishstat.gui.properties.dataset.selection.DatasetSelectionPage;

public class KeyFilterComposite
extends Composite
implements IReferenceObjectProcessor,
Observer {
    private ConceptSelection selection;
    private Table table;
    private ParentRelationSelection parentSelection = null;
    private ConceptProperties displayProperties;
    private DimensionProperties dimensionProperties;
    private ParentSelector parentSelector;
    private ReferenceList refObjectListExclude;
    private ReferenceList refObjectListInclude;
    private static final Color INCLUDE_COLOR = ComponentsCommons.getColor((int)0, (int)0, (int)128);
    private static final Color EXCLUDE_COLOR = ComponentsCommons.getColor((int)128, (int)0, (int)0);
    private static final Image ALL_ELEMENTS_IMAGE_EN = Activator.getImage("res/messages/allincluded_" + Activator.getLanguage() + ".png");
    private Composite compositeCentre;
    private FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Button butExclude;
    private Composite compositeLeft;
    private Composite cmpLowerBand;
    private Button btnP;
    private boolean initialized = false;

    public KeyFilterComposite(Composite parent, int style, ConceptSelection selection, DimensionProperties properties) {
        super(parent, style);
        this.setBackground(ComponentsCommons.getColor((int)1));
        this.setBackgroundMode(2);
        this.selection = selection;
        this.selection.addObserver((Observer)this);
        this.dimensionProperties = properties;
        this.dimensionProperties.addObserver((Observer)this);
        if (selection != null) {
            this.parentSelection = new ParentRelationSelection(selection.getConcept());
        }
        this.setDragDetect(false);
        this.initComponents();
        this.cmpLowerBand = new Composite((Composite)this, 0);
        GridData gd_cmpLowerBand = new GridData(4, 4, true, false, 3, 1);
        gd_cmpLowerBand.widthHint = 75;
        gd_cmpLowerBand.heightHint = 28;
        this.cmpLowerBand.setLayoutData((Object)gd_cmpLowerBand);
        this.toolkit.adapt(this.cmpLowerBand);
        this.toolkit.paintBordersFor(this.cmpLowerBand);
        GridLayout gl_cmpLowerBand = new GridLayout(2, false);
        gl_cmpLowerBand.verticalSpacing = 0;
        gl_cmpLowerBand.marginWidth = 0;
        gl_cmpLowerBand.marginHeight = 0;
        gl_cmpLowerBand.horizontalSpacing = 3;
        this.cmpLowerBand.setLayout((Layout)gl_cmpLowerBand);
        this.btnP = new Button(this.cmpLowerBand, 0x800000);
        this.btnP.setToolTipText(Activator.getLocalString("label.selection.mode.preferences"));
        this.btnP.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
                TimeSeriesProperties propertiesMainPage = session.getTimeseriesProperties();
                PreferenceManager mgr = new PreferenceManager('/');
                DatasetSelectionPage selectionPropertiesPage = new DatasetSelectionPage(propertiesMainPage, KeyFilterComposite.this.dimensionProperties.getDimension());
                PreferenceNode selectionPropertiesNode = new PreferenceNode("selection", (IPreferencePage)selectionPropertiesPage);
                mgr.addToRoot((IPreferenceNode)selectionPropertiesNode);
                PreferenceDialog prefDialog = new PreferenceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mgr);
                prefDialog.setBlockOnOpen(true);
                prefDialog.setSelectedNode("selection");
                prefDialog.open();
            }
        });
        this.btnP.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/properties.png"));
        GridData gridData_1 = new GridData(4, 128, false, true, 1, 1);
        gridData_1.widthHint = 33;
        this.btnP.setLayoutData((Object)gridData_1);
        this.btnP.setBounds(0, 0, 68, 23);
        this.toolkit.adapt((Control)this.btnP, true, true);
        Label label = new Label(this.cmpLowerBand, 0);
        label.setFont(SWTResourceManager.getFont("Tahoma", 8, 1));
        label.setForeground(SWTResourceManager.getColor(41, 98, 183));
        GridData gd_label = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_label.widthHint = 287;
        label.setLayoutData((Object)gd_label);
        label.setText(Activator.getLocalString("label.selection.mode.preferences"));
    }

    protected void initComponents() {
        if (this.initialized) {
            return;
        }
        if (this.selection != null) {
            this.displayProperties = this.dimensionProperties.getSelector(this.selection.getConcept().getAcronym());
        }
        GridLayout gridLayout_4 = new GridLayout(3, false);
        gridLayout_4.marginTop = 2;
        gridLayout_4.marginRight = 2;
        gridLayout_4.marginLeft = 2;
        gridLayout_4.marginBottom = 2;
        gridLayout_4.verticalSpacing = 2;
        gridLayout_4.marginWidth = 2;
        gridLayout_4.marginHeight = 2;
        gridLayout_4.horizontalSpacing = 2;
        this.setLayout((Layout)gridLayout_4);
        this.compositeLeft = new Composite((Composite)this, 0);
        GridData gd_compositeLeft = new GridData(4, 4, true, true, 1, 1);
        gd_compositeLeft.widthHint = 250;
        this.compositeLeft.setLayoutData((Object)gd_compositeLeft);
        this.compositeLeft.setBackground(ComponentsCommons.getColor((int)1));
        this.compositeLeft.setBackgroundMode(2);
        GridLayout gl_compositeLeft = new GridLayout();
        gl_compositeLeft.marginWidth = 0;
        gl_compositeLeft.marginHeight = 0;
        gl_compositeLeft.horizontalSpacing = 0;
        this.compositeLeft.setLayout((Layout)gl_compositeLeft);
        this.refObjectListInclude = new ReferenceList(this.compositeLeft, 0, this.displayProperties, Activator.getLanguage());
        this.refObjectListInclude.setBackground(ComponentsCommons.getColor((int)1));
        this.refObjectListInclude.setBackgroundMode(2);
        this.refObjectListInclude.setType("include");
        this.refObjectListInclude.setContentProvider((IContentProvider)new KeyFilterContentProvider(this.dimensionProperties));
        GridData gd_refObjectListInclude = new GridData(4, 4, true, true);
        gd_refObjectListInclude.widthHint = 108;
        gd_refObjectListInclude.heightHint = 330;
        this.refObjectListInclude.setLayoutData((Object)gd_refObjectListInclude);
        this.refObjectListInclude.setTitle(Activator.getLocalString("label.include.first.upper"));
        this.refObjectListInclude.setForegroundListColor(INCLUDE_COLOR);
        this.refObjectListInclude.setTitleColor(INCLUDE_COLOR);
        this.refObjectListInclude.addDoubleClickListener((IDoubleClickListener)new ReferenceObjectDoubleClickListener());
        if (!Beans.isDesignTime()) {
            MenusUtils.createRigthClickMenu((Concept)this.dimensionProperties.getDimensionConcept(), (Control)this.refObjectListInclude.getViewer().getControl(), (DimensionProperties)this.dimensionProperties, (String)Activator.getLanguage());
        }
        this.refObjectListInclude.setInput((Observable)this.selection);
        this.defineBackground((Composite)this.refObjectListInclude);
        this.toolkit.adapt((Composite)this.refObjectListInclude);
        this.compositeCentre = new Composite((Composite)this, 0);
        this.compositeCentre.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.compositeCentre.setBackgroundMode(2);
        this.compositeCentre.setBackground(ComponentsCommons.getColor((int)1));
        GridLayout gl_compositeCentre = new GridLayout();
        gl_compositeCentre.verticalSpacing = 1;
        gl_compositeCentre.horizontalSpacing = 0;
        gl_compositeCentre.marginWidth = 0;
        gl_compositeCentre.marginHeight = 0;
        this.compositeCentre.setLayout((Layout)gl_compositeCentre);
        Composite compositeButtons = this.toolkit.createComposite(this.compositeCentre, 0);
        compositeButtons.setBackgroundMode(2);
        GridData gd_compositeButtons = new GridData(4, 0x1000000, true, false);
        gd_compositeButtons.heightHint = 140;
        gd_compositeButtons.widthHint = 252;
        compositeButtons.setLayoutData((Object)gd_compositeButtons);
        compositeButtons.setBackground(ComponentsCommons.getColor((int)1));
        GridLayout gl_compositeButtons = new GridLayout();
        gl_compositeButtons.marginWidth = 20;
        gl_compositeButtons.marginTop = 15;
        gl_compositeButtons.marginRight = 20;
        gl_compositeButtons.marginLeft = 20;
        gl_compositeButtons.marginHeight = 20;
        gl_compositeButtons.marginBottom = 20;
        gl_compositeButtons.horizontalSpacing = 20;
        gl_compositeButtons.verticalSpacing = 20;
        gl_compositeButtons.makeColumnsEqualWidth = true;
        gl_compositeButtons.numColumns = 2;
        compositeButtons.setLayout((Layout)gl_compositeButtons);
        this.toolkit.paintBordersFor(compositeButtons);
        Button but_include = this.toolkit.createButton(compositeButtons, "", 0);
        but_include.setImage(Activator.getImage("icons/apps/resultset_previous.png"));
        but_include.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyFilterComposite.this.transferSelectedToOneSide(true);
            }
        });
        but_include.setImage(Activator.getImage("icons/base/24-arrow-previous-blue.png"));
        GridData gd_but_include = new GridData(4, 0x1000000, true, false);
        gd_but_include.heightHint = 25;
        gd_but_include.widthHint = 100;
        but_include.setLayoutData((Object)gd_but_include);
        this.butExclude = this.toolkit.createButton(compositeButtons, "", 0);
        this.butExclude.setImage(Activator.getImage("icons/apps/resultset_next.png"));
        this.butExclude.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyFilterComposite.this.transferSelectedToOneSide(false);
            }
        });
        this.butExclude.setImage(Activator.getImage("icons/base/24-arrow-next-blue.png"));
        GridData gd_but_exclude = new GridData(4, 0x1000000, true, false);
        gd_but_exclude.heightHint = 25;
        gd_but_exclude.widthHint = 100;
        this.butExclude.setLayoutData((Object)gd_but_exclude);
        Button but_all_include = this.toolkit.createButton(compositeButtons, "", 0);
        but_all_include.setImage(Activator.getImage("icons/apps/resultset_first.png"));
        but_all_include.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyFilterComposite.this.selection.includeAll();
            }
        });
        but_all_include.setImage(Activator.getImage("icons/base/24-arrow-back-blue.png"));
        GridData gd_but_all_include = new GridData(4, 0x1000000, true, false);
        gd_but_all_include.heightHint = 25;
        gd_but_all_include.widthHint = 125;
        but_all_include.setLayoutData((Object)gd_but_all_include);
        Button but_all_exclude = this.toolkit.createButton(compositeButtons, "", 0);
        but_all_exclude.setImage(Activator.getImage("icons/apps/resultset_last.png"));
        but_all_exclude.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeyFilterComposite.this.selection.excludeAll();
            }
        });
        but_all_exclude.setImage(Activator.getImage("icons/base/24-arrow-forward-blue.png"));
        GridData gd_but_all_exclude = new GridData(4, 0x1000000, true, false);
        gd_but_all_exclude.heightHint = 25;
        gd_but_all_exclude.widthHint = 100;
        but_all_exclude.setLayoutData((Object)gd_but_all_exclude);
        this.parentSelector = new ParentSelector(this.compositeCentre, 2, this.parentSelection, this.selection, this.dimensionProperties, Activator.getLanguage());
        this.parentSelector.setProcessor((IReferenceObjectProcessor)this);
        this.table = this.parentSelector.getTableViewer().getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        GridData gd_refGroupsSelector = new GridData(4, 4, true, true);
        gd_refGroupsSelector.heightHint = 223;
        gd_refGroupsSelector.widthHint = 238;
        this.parentSelector.setLayoutData((Object)gd_refGroupsSelector);
        this.toolkit.adapt((Composite)this.parentSelector);
        Composite compositeRight = new Composite((Composite)this, 0);
        GridData gd_compositeRight = new GridData(4, 4, true, true, 1, 1);
        gd_compositeRight.widthHint = 250;
        compositeRight.setLayoutData((Object)gd_compositeRight);
        GridLayout gl_compositeRight = new GridLayout();
        gl_compositeRight.marginWidth = 0;
        gl_compositeRight.marginHeight = 0;
        gl_compositeRight.horizontalSpacing = 0;
        compositeRight.setLayout((Layout)gl_compositeRight);
        this.refObjectListExclude = new ReferenceList(compositeRight, 0, this.displayProperties, Activator.getLanguage());
        this.refObjectListExclude.setBackground(ComponentsCommons.getColor((int)1));
        this.refObjectListExclude.setBackgroundMode(2);
        this.refObjectListExclude.setType("exclude");
        this.refObjectListExclude.setContentProvider((IContentProvider)new KeyFilterContentProvider(this.dimensionProperties));
        GridData gd_refObjectListExclude = new GridData(4, 4, true, true);
        gd_refObjectListExclude.widthHint = 104;
        gd_refObjectListExclude.heightHint = 369;
        this.refObjectListExclude.setLayoutData((Object)gd_refObjectListExclude);
        this.refObjectListExclude.setTitle(Activator.getLocalString("label.exclude.first.upper"));
        this.refObjectListExclude.setTitleColor(EXCLUDE_COLOR);
        this.refObjectListExclude.addDoubleClickListener((IDoubleClickListener)new ReferenceObjectDoubleClickListener());
        this.refObjectListExclude.setForegroundListColor(EXCLUDE_COLOR);
        this.refObjectListExclude.setInput((Observable)this.selection);
        if (!Beans.isDesignTime()) {
            MenusUtils.createRigthClickMenu((Concept)this.dimensionProperties.getDimensionConcept(), (Control)this.refObjectListExclude.getViewer().getControl(), (DimensionProperties)this.dimensionProperties, (String)Activator.getLanguage());
        }
        this.toolkit.adapt((Composite)this.refObjectListExclude);
        this.layout(true);
        this.initialized = true;
    }

    protected void checkSubclass() {
    }

    private void transferSelectedToOneSide(boolean includes) {
        if (includes) {
            LinkedList selectedROs = new LinkedList(this.refObjectListExclude.getSelectedItems());
            LinkedList previousExclude = this.refObjectListExclude.getSelectionPrevious(selectedROs);
            this.selection.addIncludes(this.refObjectListExclude.getSelectedItems());
            this.refObjectListInclude.setSelection(selectedROs);
            if (previousExclude != null) {
                this.refObjectListExclude.setSelection((List)previousExclude);
            }
        } else {
            LinkedList selectedROs = new LinkedList(this.refObjectListInclude.getSelectedItems());
            LinkedList previousInclude = this.refObjectListInclude.getSelectionPrevious(selectedROs);
            this.selection.remIncludes(this.refObjectListInclude.getSelectedItems());
            this.refObjectListExclude.setSelection(selectedROs);
            if (previousInclude != null) {
                this.refObjectListInclude.setSelection((List)previousInclude);
            }
        }
    }

    private void highlightItemsToExclude(Relationship rel, ReferenceObject father) {
        try {
            Set childs_list = rel.getChildren(father);
            this.selection.remIncludes(childs_list);
            this.refObjectListExclude.setSelection(new LinkedList(childs_list));
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
        }
    }

    private void highlightItemsToInclude(Relationship rel, ReferenceObject father) {
        try {
            Set childs_list = rel.getChildren(father);
            this.selection.addIncludes(childs_list);
            this.refObjectListInclude.setSelection(new LinkedList(childs_list));
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
        }
    }

    private void highlightItems(Relationship rel, ReferenceObject father) {
        try {
            Set childs_list = rel.getChildren(father);
            this.refObjectListInclude.setSelection(new LinkedList());
            this.refObjectListInclude.setSelection(new LinkedList(childs_list));
            this.refObjectListExclude.setSelection(new LinkedList());
            this.refObjectListExclude.setSelection(new LinkedList(childs_list));
        }
        catch (ReferenceServiceException e) {
            e.printStackTrace();
        }
    }

    public void processReferenceObject(ReferenceObject o, Object arg) {
        if (arg.equals("include")) {
            this.highlightItemsToInclude(this.parentSelection.getSelectedRelationship(), o);
        } else if (arg.equals("exclude")) {
            this.highlightItemsToExclude(this.parentSelection.getSelectedRelationship(), o);
        } else if (arg.equals("both")) {
            this.highlightItems(this.parentSelection.getSelectedRelationship(), o);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.selection != null) {
            if (o instanceof DimensionProperties && this.selection.hasChanged()) {
                this.selection.initialize(this.dimensionProperties.getAllReferenceData());
            }
            if (o instanceof ConceptSelection) {
                this.refObjectListInclude.setInput((Observable)this.selection);
                this.defineBackground((Composite)this.refObjectListInclude);
                this.refObjectListExclude.setInput((Observable)this.selection);
            }
        }
    }

    private void defineBackground(Composite composite) {
        if (!composite.isDisposed()) {
            if (this.refObjectListInclude.getViewer().getList().getItemCount() == 0) {
                this.refObjectListInclude.setBackgroundImage(this.getAdHocBackgroundImage(composite));
            } else {
                this.refObjectListInclude.setBackgroundImage(null);
            }
        }
    }

    private Image getAdHocBackgroundImage(Composite composite) {
        Rectangle rect = new Rectangle(0, 0, composite.computeSize((int)-1, (int)-1).y, composite.computeSize((int)-1, (int)-1).x);
        Image newImage = new Image((Device)composite.getDisplay(), rect.width, rect.height * 4);
        GC gc = new GC((Drawable)newImage);
        gc.drawImage(ALL_ELEMENTS_IMAGE_EN, rect.width / 2 - 175, 50);
        gc.dispose();
        return newImage;
    }

    class ReferenceObjectDoubleClickListener
    implements IDoubleClickListener {
        ReferenceObjectDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            if (!event.getSelection().isEmpty()) {
                ListViewer lw = (ListViewer)event.getSource();
                if (lw.getList().getParent().equals(KeyFilterComposite.this.refObjectListExclude)) {
                    KeyFilterComposite.this.transferSelectedToOneSide(true);
                } else {
                    KeyFilterComposite.this.transferSelectedToOneSide(false);
                }
            }
        }
    }
}

