/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.edit;

import com.csvreader.CsvWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.composites.DimensionMetadataPanel;
import org.fao.fi.fishstat.gui.components.composites.DimensionTabbedDisplay;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;

public class DimensionCopyHandler {
    public DimensionCopyHandler(DimensionTabbedDisplay dimensionTabbedDisplay, ExportSettings exportSettings) {
        try {
            TableItem[] items;
            int dimIndex = dimensionTabbedDisplay.getTabFolder().getSelectionIndex();
            if (dimIndex == -1) {
                return;
            }
            StringWriter writer = new StringWriter();
            CsvWriter csw = new CsvWriter((Writer)writer, ',');
            csw.setTextQualifier('\"');
            csw.setForceQualifier(true);
            DimensionMetadataPanel dimnsionPanel = (DimensionMetadataPanel)dimensionTabbedDisplay.getTabFolder().getItem(dimIndex).getControl();
            String[] columnHeaders = dimnsionPanel.getColumnHeaders();
            if (exportSettings.isExportHeaders()) {
                csw.write(String.valueOf(Activator.getLocalString("label.topother.dataset")) + " " + dimensionTabbedDisplay.getDataset().getName().getValue(CoreCommons.LOCALE2));
                csw.endRecord();
                csw.write(String.valueOf(Activator.getLocalString("label.concept.first.upper")) + ": " + dimnsionPanel.getDimension().getName().getValue(CoreCommons.LOCALE2) + " (" + dimnsionPanel.getDimension().getAcronym() + ")");
                csw.endRecord();
                int i = 0;
                while (i < columnHeaders.length) {
                    csw.write(columnHeaders[i]);
                    ++i;
                }
                csw.endRecord();
            }
            TableItem[] tableItemArray = items = dimnsionPanel.getTableView().getTable().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                ReferenceObject ro = (ReferenceObject)tableItem.getData();
                int i = 0;
                while (i < columnHeaders.length) {
                    csw.write(dimnsionPanel.getColumnText(ro, i));
                    ++i;
                }
                csw.endRecord();
                ++n2;
            }
            if (exportSettings.isExportCitation() && dimensionTabbedDisplay.getDataset().getCitation() != null) {
                csw.write(dimensionTabbedDisplay.getDataset().getCitation().getValue(CoreCommons.LOCALE2));
                csw.endRecord();
            }
            csw.endRecord();
            Clipboard clipboard = new Clipboard(Display.getDefault());
            clipboard.setContents(new Object[]{writer.getBuffer().toString()}, new Transfer[]{TextTransfer.getInstance()});
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Export done", (String)(String.valueOf(dimnsionPanel.getDimension().getName().getValue(CoreCommons.LOCALE2)) + " was copied to the clipboard"));
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "Metadata copy/paste", (Throwable)e));
        }
    }
}

