/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.datadisplay;

import java.beans.Beans;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationPreferences;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class FormatHilitePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    public static final String ID = "org.fao.fi.fishstat.gui.preferences.datatadisplay.hilite";
    private IPreferenceStore prefstore;
    private Combo[] combos;
    private Label[] labels;
    private Display display = PlatformUI.createDisplay();

    protected Control createContents(Composite parent) {
        this.labels = new Label[ApplicationPreferences.getgetDataDisplaySize()];
        this.combos = new Combo[ApplicationPreferences.getgetDataDisplaySize()];
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 4;
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        gridLayout.numColumns = 4;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label showOfficialLabel = new Label(composite, 0);
        showOfficialLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.official.label"));
        showOfficialLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Combo cbOffcial = new Combo(composite, 8);
        cbOffcial.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        cbOffcial.setItems(new String[]{"[blank]"});
        cbOffcial.select(0);
        new Label(composite, 0);
        new Label(composite, 0);
        Label showUnavailableLabel = new Label(composite, 0);
        showUnavailableLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.unavailable.label"));
        showUnavailableLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Combo combo1 = new Combo(composite, 8);
        combo1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[0] = combo1;
        GridData gdCombo1 = new GridData(4, 0x1000000, false, false);
        this.combos[0].setLayoutData((Object)gdCombo1);
        this.combos[0].setItems(UNAVAILABLE_LABELS);
        this.labels[0] = new Label(composite, 0);
        this.labels[0].setText(Activator.getPluginBundle().getString("preferences.data.display.format.color"));
        Button btnPickUnavailable = new Button(composite, 0);
        btnPickUnavailable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(0);
            }
        });
        btnPickUnavailable.setImage(Activator.getImage("icons/base/choose-color.png"));
        btnPickUnavailable.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label showNegligibleValuesLabel = new Label(composite, 0);
        showNegligibleValuesLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        showNegligibleValuesLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.negligible.label"));
        Combo combo2 = new Combo(composite, 8);
        combo2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[2] = combo2;
        this.combos[2].setItems(NEGLIGIBLE_LABELS);
        GridData gdCombo2 = new GridData(4, 0x1000000, false, false);
        this.combos[2].setLayoutData((Object)gdCombo2);
        this.labels[2] = new Label(composite, 0);
        this.labels[2].setText(Activator.getPluginBundle().getString("preferences.data.display.format.color"));
        Button btnPickNegligible = new Button(composite, 0);
        btnPickNegligible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(2);
            }
        });
        btnPickNegligible.setImage(Activator.getImage("icons/base/choose-color.png"));
        btnPickNegligible.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label showZeroesAsLabel = new Label(composite, 0);
        showZeroesAsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        showZeroesAsLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.zeroes.label"));
        Combo combo4 = new Combo(composite, 8);
        combo4.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[1] = combo4;
        this.combos[1].setItems(ZEROES_LABELS);
        GridData gd_cmb_zeroes = new GridData(4, 0x1000000, false, false);
        this.combos[1].setLayoutData((Object)gd_cmb_zeroes);
        this.labels[1] = new Label(composite, 0);
        this.labels[1].setText(Activator.getPluginBundle().getString("preferences.data.display.format.color"));
        Button btnPickZeroes = new Button(composite, 0);
        btnPickZeroes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(1);
            }
        });
        btnPickZeroes.setImage(Activator.getImage("icons/base/choose-color.png"));
        btnPickZeroes.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label showEstimateAsLabel = new Label(composite, 0);
        showEstimateAsLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        showEstimateAsLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.estimates.label"));
        Combo combo5 = new Combo(composite, 8);
        combo5.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[3] = combo5;
        GridData gd_cmb_estimate = new GridData(4, 0x1000000, false, false);
        this.combos[3].setLayoutData((Object)gd_cmb_estimate);
        this.combos[3].setItems(ESTIMATE_LABELS);
        this.labels[3] = new Label(composite, 0);
        this.labels[3].setText(Activator.getPluginBundle().getString("preferences.data.display.format.color"));
        Button btnPickEstimate = new Button(composite, 0);
        btnPickEstimate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(3);
            }
        });
        btnPickEstimate.setImage(Activator.getImage("icons/base/choose-color.png"));
        btnPickEstimate.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label showMirroredLabel = new Label(composite, 0);
        showMirroredLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        showMirroredLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.mirrored.label"));
        Combo comboMirrored = new Combo(composite, 8);
        comboMirrored.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[4] = comboMirrored;
        this.combos[4].setItems(MIRRORED_LABELS);
        GridData gdComboMirrored = new GridData(4, 0x1000000, false, false);
        this.combos[4].setLayoutData((Object)gdComboMirrored);
        this.labels[4] = new Label(composite, 0);
        this.labels[4].setText(Activator.getPluginBundle().getString("preferences.data.display.format.color"));
        Button btnPickMirrored = new Button(composite, 0);
        btnPickMirrored.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(4);
            }
        });
        btnPickMirrored.setImage(Activator.getImage("icons/base/choose-color.png"));
        btnPickMirrored.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Label showImputedLabel = new Label(composite, 0);
        showImputedLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        showImputedLabel.setText(Activator.getPluginBundle().getString("preferences.data.display.format.hilite.imputed.label"));
        Combo comboImputed = new Combo(composite, 8);
        comboImputed.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[5] = comboImputed;
        this.combos[5].setItems(IMPUTED_LABELS);
        GridData gdComboImputed = new GridData(4, 0x1000000, false, false);
        this.combos[5].setLayoutData((Object)gdComboImputed);
        this.labels[5] = new Label(composite, 0);
        this.labels[5].setText(Activator.getPluginBundle().getString("preferences.data.display.format.color"));
        Button btnPickImputed = new Button(composite, 0);
        btnPickImputed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(5);
            }
        });
        btnPickImputed.setImage(Activator.getImage("icons/base/choose-color.png"));
        btnPickImputed.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        if (!Beans.isDesignTime()) {
            this.prefstore = Activator.getDefault().getPreferenceStore();
        }
        this.syncroPanel();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.combos[0].getSelectionIndex() != -1) {
            this.prefstore.setValue("display.hilite.unavailable", this.combos[0].getSelectionIndex());
        }
        if (this.combos[2].getSelectionIndex() != -1) {
            this.prefstore.setValue("display.hilite.negligible", this.combos[2].getSelectionIndex());
        }
        if (this.combos[1].getSelectionIndex() != -1) {
            this.prefstore.setValue("display.hilite.zeroes", this.combos[1].getSelectionIndex());
        }
        if (this.combos[3].getSelectionIndex() != -1) {
            this.prefstore.setValue("display.hilite.estimate", this.combos[3].getSelectionIndex());
        }
        if (this.combos[4].getSelectionIndex() != -1) {
            this.prefstore.setValue("display.hilite.mirrored", this.combos[4].getSelectionIndex());
        }
        if (this.combos[5].getSelectionIndex() != -1) {
            this.prefstore.setValue("display.hilite.imputed", this.combos[5].getSelectionIndex());
        }
        this.prefstore.setValue("display.hilite.unavailable.color", StringConverter.asString((RGB)ApplicationPreferences.getDataDisplayColors(0).getRGB()));
        this.prefstore.setValue("display.hilite.negligible.color", StringConverter.asString((RGB)ApplicationPreferences.getDataDisplayColors(2).getRGB()));
        this.prefstore.setValue("display.hilite.zeroes.color", StringConverter.asString((RGB)ApplicationPreferences.getDataDisplayColors(1).getRGB()));
        this.prefstore.setValue("display.hilite.estimate.color", StringConverter.asString((RGB)ApplicationPreferences.getDataDisplayColors(3).getRGB()));
        this.prefstore.setValue("display.hilite.mirrored.color", StringConverter.asString((RGB)ApplicationPreferences.getDataDisplayColors(4).getRGB()));
        this.prefstore.setValue("display.hilite.imputed.color", StringConverter.asString((RGB)ApplicationPreferences.getDataDisplayColors(5).getRGB()));
        try {
            ((IPersistentPreferenceStore)this.prefstore).save();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "saving preferences", (Throwable)e));
        }
        return super.performOk();
    }

    protected void syncroPanel() {
        if (!Beans.isDesignTime()) {
            this.combos[0].select(this.getIntPerference("display.hilite.unavailable", UNAVAILABLE_LABELS));
            this.labels[0].setForeground(ApplicationPreferences.getDataDisplayColors(0));
            this.combos[2].select(this.getIntPerference("display.hilite.negligible", NEGLIGIBLE_LABELS));
            this.labels[2].setForeground(ApplicationPreferences.getDataDisplayColors(2));
            this.combos[1].select(this.getIntPerference("display.hilite.zeroes", ZEROES_LABELS));
            this.labels[1].setForeground(ApplicationPreferences.getDataDisplayColors(1));
            this.combos[3].select(this.getIntPerference("display.hilite.estimate", ESTIMATE_LABELS));
            this.labels[3].setForeground(ApplicationPreferences.getDataDisplayColors(3));
            this.combos[4].select(this.getIntPerference("display.hilite.mirrored", MIRRORED_LABELS));
            this.labels[4].setForeground(ApplicationPreferences.getDataDisplayColors(4));
            this.combos[5].select(this.getIntPerference("display.hilite.imputed", IMPUTED_LABELS));
            this.labels[5].setForeground(ApplicationPreferences.getDataDisplayColors(5));
        }
    }

    private int getIntPerference(String preferenceName, String[] preferenceLabels) {
        int prefValue = this.prefstore.getInt(preferenceName);
        if (prefValue < 0 || prefValue > preferenceLabels.length) {
            return this.prefstore.getDefaultInt(preferenceName);
        }
        return prefValue;
    }

    protected void performDefaults() {
        if (!Beans.isDesignTime()) {
            this.combos[0].select(this.prefstore.getDefaultInt("display.hilite.unavailable"));
            ApplicationPreferences.setDataDisplayColors(0, new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.unavailable.color"))));
            this.labels[0].setForeground(ApplicationPreferences.getDataDisplayColors(0));
            this.combos[2].select(this.prefstore.getDefaultInt("display.hilite.negligible"));
            ApplicationPreferences.setDataDisplayColors(2, new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.negligible.color"))));
            this.labels[2].setForeground(ApplicationPreferences.getDataDisplayColors(2));
            this.combos[1].select(this.prefstore.getDefaultInt("display.hilite.zeroes"));
            ApplicationPreferences.setDataDisplayColors(1, new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.zeroes.color"))));
            this.labels[1].setForeground(ApplicationPreferences.getDataDisplayColors(1));
            this.combos[3].select(this.prefstore.getDefaultInt("display.hilite.estimate"));
            ApplicationPreferences.setDataDisplayColors(3, new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.estimate.color"))));
            this.labels[3].setForeground(ApplicationPreferences.getDataDisplayColors(3));
            this.combos[4].select(this.prefstore.getDefaultInt("display.hilite.mirrored"));
            ApplicationPreferences.setDataDisplayColors(4, new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.mirrored.color"))));
            this.labels[4].setForeground(ApplicationPreferences.getDataDisplayColors(4));
            this.combos[5].select(this.prefstore.getDefaultInt("display.hilite.imputed"));
            ApplicationPreferences.setDataDisplayColors(5, new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.imputed.color"))));
            this.labels[5].setForeground(ApplicationPreferences.getDataDisplayColors(5));
            super.performDefaults();
        }
    }

    protected void assignColor(int hilite) {
        ColorDialog cd = new ColorDialog(this.getShell());
        cd.setText(Activator.getPluginBundle().getString("label.color.assignment"));
        cd.setRGB(ApplicationPreferences.getDataDisplayColors(hilite).getRGB());
        RGB newColor = cd.open();
        if (newColor != null) {
            ApplicationPreferences.setDataDisplayColors(hilite, new Color((Device)this.display, newColor));
            this.labels[hilite].setForeground(ApplicationPreferences.getDataDisplayColors(hilite));
        }
    }
}

