/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.columns.dimensions;

import java.util.Collection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.properties.dataset.columns.dimensions.DimensionDisplayComposite;

public class DatasetDisplayComposite
extends Composite {
    private TimeSeriesProperties properties;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    public DatasetDisplayComposite(Composite parent, TimeSeriesProperties p) {
        super(parent, 0);
        this.properties = p;
        this.initComponents();
    }

    private void initComponents() {
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(1, false));
        Section sctDimensions = this.toolkit.createSection((Composite)this, 256);
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.verticalIndent = 15;
        gridData.horizontalIndent = 5;
        sctDimensions.setLayoutData((Object)gridData);
        sctDimensions.setText(Activator.getLocalString("label.dimensions.first.upper"));
        Composite cmpDimensionsBase = this.toolkit.createComposite((Composite)sctDimensions, 0);
        cmpDimensionsBase.setLayout((Layout)new GridLayout(1, false));
        CTabFolder tabFolder = new CTabFolder(cmpDimensionsBase, 0);
        GridData gd_tabFolder = new GridData(4, 4, true, true, 1, 1);
        tabFolder.setLayoutData((Object)gd_tabFolder);
        tabFolder.setForeground(ComponentsCommons.getColor((int)10));
        tabFolder.setBorderVisible(false);
        tabFolder.setBackground(ComponentsCommons.getColor((int)1));
        tabFolder.setSelectionBackground(ComponentsCommons.getColor((int)25));
        Collection dimensionsProperties = this.properties.getDatasetProperties().getDimensionsProperties();
        for (DimensionProperties dimensionProperties : dimensionsProperties) {
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            try {
                tabItem.setText("  " + CoreUtils.getCurrentLangName((Object)dimensionProperties.getDimension(), (String)Activator.getLanguage()) + "  ");
            }
            catch (Exception e) {
                ComponentsCommons.showExceptionWithStack((Throwable)e);
            }
            tabItem.setControl((Control)new DimensionDisplayComposite((Composite)tabFolder, 0, dimensionProperties));
        }
        tabFolder.setSelection(0);
        sctDimensions.setClient((Control)cmpDimensionsBase);
    }

    protected void applyData() {
    }

    protected void syncroPanel() {
    }
}

