/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.status;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculator;
import org.fao.fi.fishstat.data.timeseries.status.MeasureStatusCalculatorFAO;

public class MeasureStatusCalculatorFactory {
    private static Map<DataSource, MeasureStatusCalculator> instances = new HashMap<DataSource, MeasureStatusCalculator>();

    static {
        MeasureStatusCalculatorFactory.register(DataSource.UNDEFINED, new MeasureStatusCalculator(){

            @Override
            public void reset() {
            }

            @Override
            public void calculate(ObservationSeries aggregated, ObservationSeries series) {
                for (Measure measure : aggregated.getMeasures().values()) {
                    measure.setStatus(MeasureStatus.STATUS_OFFICIAL);
                }
            }
        });
        MeasureStatusCalculatorFactory.register(DataSource.FAO, new MeasureStatusCalculatorFAO());
    }

    private MeasureStatusCalculatorFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static final MeasureStatusCalculator instance(DataSource dataSource) {
        MeasureStatusCalculator calculator = instances.get(dataSource);
        if (calculator == null) {
            calculator = instances.get(DataSource.UNDEFINED);
        }
        return calculator;
    }

    public static final void register(DataSource dataSource, MeasureStatusCalculator calculator) {
        instances.put(dataSource, calculator);
    }
}

