/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.fao.fi.fishstat.gui.ApplicationPreferences;
import org.fao.fi.fishstat.gui.StatusBarController;
import org.fao.fi.fishstat.gui.components.dialogs.NotYetImplementedDialog;
import org.fao.fi.fishstat.gui.preferences.ApplicationPreferencesInitializer;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.fao.fi.fishstat.gui";
    public static final Boolean isWindows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    private static String LOCALE2 = Platform.getNL().substring(0, 2);
    private static Activator plugin;
    private StatusBarController statusBarController = null;
    private IPreferenceStore store = null;
    private static ResourceBundle pluginBundle;

    static {
        pluginBundle = ResourceBundle.getBundle("plugin");
    }

    public Activator() {
        if (!(LOCALE2.equals("en") || LOCALE2.equals("fr") || LOCALE2.equals("es"))) {
            LOCALE2 = "en";
            System.out.println("org.fao.fi.fishstat.gui.Activator locale is : " + Platform.getNL() + " setting to " + LOCALE2);
        } else {
            System.out.println("org.fao.fi.fishstat.gui.Activator locale : " + Platform.getNL());
        }
    }

    public static String getLanguage() {
        return LOCALE2;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "fishstatj.gui");
        new ApplicationPreferencesInitializer().initializeDefaultPreferences();
        ApplicationPreferences.assignPreferences();
        this.statusBarController = new StatusBarController();
        Activator.getDefault().getLog().log((IStatus)new Status(1, ((Object)((Object)this)).getClass().getName(), String.valueOf(isWindows != false ? "isWindows" : "notWindows") + ", DPI_CURRENT=" + Float.toString(Display.getDefault().getDPI().x) + ", DPI_SCALE=" + Float.toString((float)Display.getDefault().getDPI().x / 96.0f)));
    }

    public static Point windowsScaling(int x, int y) {
        if (isWindows.booleanValue()) {
            float factor = (float)Display.getDefault().getDPI().x / 96.0f;
            if (factor < 1.0f) {
                factor = 1.0f;
            }
            return new Point(Math.round((float)x * factor), Math.round((float)y * factor));
        }
        return new Point(x, y);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void changeLocale(String locale) {
        block11: {
            String path = String.valueOf(Platform.getInstallLocation().getURL().getFile()) + "configuration" + System.getProperty("file.separator") + "config.ini";
            Properties props = new Properties();
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(path);
                    props.load(fis);
                    fis.close();
                    props.setProperty("osgi.nl", locale);
                    fos = new FileOutputStream(path);
                    props.store(fos, "Edited by FishstatJ");
                    fos.close();
                }
                catch (Exception exception) {
                    try {
                        fis.close();
                        fos.close();
                    }
                    catch (Exception exception2) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    fos.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fis.close();
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void notYetImplementedMessage() {
        NotYetImplementedDialog nyi = new NotYetImplementedDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        nyi.open();
    }

    public StatusBarController getStatusBarController() {
        return this.statusBarController;
    }

    public void setApplicationTitlePostfix(String postfix) {
        String prefix = postfix == null || postfix.equals("") ? "FishstatJ" : "FishstatJ - ";
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(String.valueOf(prefix) + postfix);
    }

    public static ImageDescriptor getImageDescriptor(String fileName) {
        Optional imagedesc = ResourceLocator.imageDescriptorFromBundle(Activator.class, (String)fileName);
        if (imagedesc.isPresent()) {
            return (ImageDescriptor)imagedesc.get();
        }
        return null;
    }

    public static Image getImage(String fileName) {
        ImageDescriptor descriptor = Activator.getImageDescriptor(fileName);
        return descriptor != null ? descriptor.createImage() : null;
    }

    public static Color getColor(int r, int g, int b) {
        return new Color((Device)PlatformUI.getWorkbench().getDisplay(), r, g, b);
    }

    public static ResourceBundle getPluginBundle() {
        return pluginBundle;
    }

    public static String getLocalString(String key) {
        try {
            return pluginBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "<@missing label@>";
        }
    }

    public IPreferenceStore getPreferenceStore() {
        return this.store;
    }
}

