/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.sorting;

import java.util.LinkedList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptAttributesComboViewer;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptParentsComboViewer;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;

public class AdvanceSorterPanel
extends Composite {
    private MultiSortElemProperties properties;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private ComboViewer vwrDimensionPeriod;
    private ConceptParentsComboViewer vwrConceptParents;
    private ConceptAttributesComboViewer vwrConceptAttributes;
    private Label lblConcept;
    private Label lblAttribute;
    private Label lblDimensionPeriod;
    private Label lblDirection;
    private Button chkActive;
    private Button azButton;
    private Button zaButton;

    public AdvanceSorterPanel(Composite parent, int style, MultiSortElemProperties ssp) {
        super(parent, style);
        this.properties = ssp;
        this.addDisposeListener(e -> this.toolkit.dispose());
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        GridLayout gridLayout = new GridLayout(6, false);
        gridLayout.verticalSpacing = 2;
        gridLayout.horizontalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        this.toolkit.adapt((Control)label, true, true);
        this.lblDimensionPeriod = new Label((Composite)this, 0);
        this.toolkit.adapt((Control)this.lblDimensionPeriod, true, true);
        this.lblDimensionPeriod.setText(Activator.getPluginBundle().getString("timeseries.sorting.panel.dimension"));
        this.lblDimensionPeriod.setForeground(SWTResourceManager.getColor(10));
        this.lblConcept = new Label((Composite)this, 0);
        this.toolkit.adapt((Control)this.lblConcept, true, true);
        this.lblConcept.setForeground(SWTResourceManager.getColor(10));
        this.lblConcept.setText(Activator.getPluginBundle().getString("label.concept.first.upper"));
        this.lblAttribute = new Label((Composite)this, 0);
        this.toolkit.adapt((Control)this.lblAttribute, true, true);
        this.lblAttribute.setForeground(SWTResourceManager.getColor(10));
        this.lblAttribute.setText(Activator.getPluginBundle().getString("label.attribute.first.upper"));
        this.lblDirection = new Label((Composite)this, 0);
        this.toolkit.adapt((Control)this.lblDirection, true, true);
        this.lblDirection.setForeground(SWTResourceManager.getColor(10));
        this.lblDirection.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.lblDirection.setText(Activator.getPluginBundle().getString("timeseries.sorting.panel.direction"));
        this.chkActive = new Button((Composite)this, 32);
        this.chkActive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvanceSorterPanel.this.setActiveStrip(AdvanceSorterPanel.this.chkActive.getSelection());
            }
        });
        this.chkActive.setForeground(SWTResourceManager.getColor(10));
        this.toolkit.adapt((Control)this.chkActive, true, true);
        this.chkActive.setText(Activator.getPluginBundle().getString("timeseries.sorting.panel.active"));
        this.chkActive.setSelection(true);
        this.vwrDimensionPeriod = new ComboViewer((Composite)this, 0);
        this.vwrDimensionPeriod.addSelectionChangedListener(event -> {
            Object selection = ((StructuredSelection)this.vwrDimensionPeriod.getSelection()).getFirstElement();
            if (selection instanceof Dimension) {
                this.setConceptParentsEnablement(true);
                this.setConceptAttributeEnablement(true);
                this.vwrConceptParents.setInput((Object)((Dimension)selection).getConcept());
                this.vwrConceptParents.setSelection((ISelection)new StructuredSelection((Object)((Dimension)selection).getConcept()));
            } else {
                this.setConceptParentsEnablement(false);
                this.setConceptAttributeEnablement(false);
            }
        });
        Combo cmbDimensionPeriod = this.vwrDimensionPeriod.getCombo();
        GridData gdCmbDimensionPeriod = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCmbDimensionPeriod.widthHint = 100;
        cmbDimensionPeriod.setLayoutData((Object)gdCmbDimensionPeriod);
        this.toolkit.paintBordersFor((Composite)cmbDimensionPeriod);
        this.vwrDimensionPeriod.setLabelProvider((IBaseLabelProvider)new DimensionPeriodsLabelProvider());
        this.vwrDimensionPeriod.setContentProvider((IContentProvider)new DimensionPeriodsContentProvider());
        this.vwrDimensionPeriod.setInput((Object)this.properties.getTimeseries());
        this.vwrConceptParents = new ConceptParentsComboViewer((Composite)this, 0, Activator.getLanguage(), true);
        this.vwrConceptParents.addSelectionChangedListener(event -> {
            Concept selectedConcept = (Concept)((StructuredSelection)this.vwrConceptParents.getSelection()).getFirstElement();
            if (selectedConcept != null) {
                this.vwrConceptAttributes.setInput((Object)selectedConcept);
                this.vwrConceptAttributes.setSelection((ISelection)new StructuredSelection((Object)selectedConcept.getNameAttribute()));
            }
        });
        Combo cmbConceptParents = this.vwrConceptParents.getCombo();
        GridData gdCmbConceptParents = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCmbConceptParents.widthHint = 100;
        cmbConceptParents.setLayoutData((Object)gdCmbConceptParents);
        this.toolkit.paintBordersFor((Composite)cmbConceptParents);
        this.vwrConceptAttributes = new ConceptAttributesComboViewer((Composite)this, 0, Activator.getLanguage());
        Combo cmbConceptAttributes = this.vwrConceptAttributes.getCombo();
        GridData gdVwrConceptAttributes = new GridData(4, 0x1000000, false, false, 1, 1);
        gdVwrConceptAttributes.widthHint = 100;
        cmbConceptAttributes.setLayoutData((Object)gdVwrConceptAttributes);
        this.toolkit.paintBordersFor((Composite)cmbConceptAttributes);
        this.azButton = new Button((Composite)this, 16);
        this.toolkit.adapt((Control)this.azButton, true, true);
        this.azButton.setImage(Activator.getImage("icons/actions/sortaz.png"));
        this.azButton.setSelection(true);
        this.zaButton = new Button((Composite)this, 16);
        this.toolkit.adapt((Control)this.zaButton, true, true);
        this.zaButton.setImage(Activator.getImage("icons/actions/sortza.png"));
        this.zaButton.setSelection(false);
        this.vwrDimensionPeriod.setSelection((ISelection)new StructuredSelection(this.vwrDimensionPeriod.getElementAt(0)));
    }

    protected void applyData() {
        this.properties.setActive(this.chkActive.getSelection());
        if (this.properties.isActive()) {
            Object dimper = ((StructuredSelection)this.vwrDimensionPeriod.getSelection()).getFirstElement();
            if (dimper instanceof Dimension) {
                this.properties.setType('D');
                this.properties.setDimension((Dimension)dimper);
                this.properties.setConcept((Concept)((StructuredSelection)this.vwrConceptParents.getSelection()).getFirstElement());
                this.properties.setAttribute((Attribute)((StructuredSelection)this.vwrConceptAttributes.getSelection()).getFirstElement());
                this.properties.setObservationPeriod(null);
            } else if (dimper instanceof ObservationPeriod) {
                this.properties.setType('S');
                this.properties.setObservationPeriod((ObservationPeriod)dimper);
                this.properties.setDimension(null);
                this.properties.setConcept(null);
                this.properties.setAttribute(null);
            }
            this.properties.setAscending(this.azButton.getSelection());
        }
    }

    public boolean sortIsActive() {
        return this.chkActive.getSelection();
    }

    public MultiSortElemProperties getProperties() {
        return this.properties;
    }

    public void setProperties(MultiSortElemProperties properties) {
        this.properties = properties;
        this.syncroPanel();
    }

    protected void syncroPanel() {
        boolean active = this.properties.isActive();
        this.setActiveStrip(active);
        this.chkActive.setSelection(active);
        if (!active) {
            return;
        }
        char type = this.properties.getType();
        if (type == 'D') {
            this.vwrDimensionPeriod.setSelection((ISelection)new StructuredSelection((Object)this.properties.getDimension()));
            this.vwrConceptParents.setSelection((ISelection)new StructuredSelection((Object)this.properties.getConcept()));
            this.vwrConceptAttributes.setSelection((ISelection)new StructuredSelection((Object)this.properties.getAttribute()));
        }
        if (type == 'S') {
            this.vwrDimensionPeriod.setSelection((ISelection)new StructuredSelection((Object)this.properties.getObservationPeriod()));
        }
        this.azButton.setSelection(this.properties.isAscending());
        this.zaButton.setSelection(!this.properties.isAscending());
    }

    private void setActiveStrip(boolean enabled) {
        this.setDimensionPeriodsEnablement(enabled);
        this.setConceptParentsEnablement(enabled);
        this.setConceptAttributeEnablement(enabled);
        this.lblDirection.setForeground(enabled ? SWTResourceManager.getColor(10) : SWTResourceManager.getColor(15));
        this.azButton.setEnabled(enabled);
        this.zaButton.setEnabled(enabled);
    }

    private void setDimensionPeriodsEnablement(boolean enabled) {
        this.lblDimensionPeriod.setForeground(enabled ? SWTResourceManager.getColor(10) : SWTResourceManager.getColor(15));
        this.vwrDimensionPeriod.setInput(enabled ? this.properties.getTimeseries() : null);
        if (enabled) {
            this.vwrDimensionPeriod.setSelection((ISelection)new StructuredSelection(this.vwrDimensionPeriod.getElementAt(0)));
        }
        this.vwrDimensionPeriod.getCombo().setEnabled(enabled);
    }

    private void setConceptParentsEnablement(boolean enabled) {
        this.lblConcept.setForeground(enabled ? SWTResourceManager.getColor(10) : SWTResourceManager.getColor(15));
        if (!enabled) {
            this.vwrConceptParents.setInput(null);
        }
        this.vwrConceptParents.getCombo().setEnabled(enabled);
    }

    private void setConceptAttributeEnablement(boolean enabled) {
        this.lblAttribute.setForeground(enabled ? SWTResourceManager.getColor(10) : SWTResourceManager.getColor(15));
        if (!enabled) {
            this.vwrConceptAttributes.setInput(null);
        }
        this.vwrConceptAttributes.getCombo().setEnabled(enabled);
    }

    private static class DimensionPeriodsContentProvider
    implements IStructuredContentProvider {
        private DimensionPeriodsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof Timeseries) {
                LinkedList result = new LinkedList();
                result.addAll(((Timeseries)inputElement).getDataset().getDimensions());
                result.addAll(((Timeseries)inputElement).getObservationPeriods());
                return result.toArray();
            }
            return new Object[0];
        }
    }

    private static class DimensionPeriodsLabelProvider
    extends LabelProvider {
        private DimensionPeriodsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Dimension) {
                return ((Dimension)element).getName().getValue(Activator.getLanguage());
            }
            if (element instanceof ObservationPeriod) {
                return ((ObservationPeriod)element).getISO8601();
            }
            return "";
        }
    }
}

