/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModelImpl;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;
import org.fao.fi.fishstat.data.common.api.workspace.Workspace;
import org.fao.fi.fishstat.data.common.api.workspace.WorkspaceManager;
import org.fao.fi.fishstat.data.common.classloader.ClassLoaderFactory;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.osgi.framework.Bundle;

public class WorkspacesManager
extends Observable {
    public static final String MSG_OPEN_WORKSPACE = "MSG_OPEN_WORKSPACE";
    public static final String MSG_CLOSE_WORKSPACE = "MSG_CLOSE_WORKSPACE";
    public static final String MSG_REFRESH_WORKSPACE = "MSG_REFRESH_WORKSPACE";
    public static final String MSG_SCAN_REGISTRY = "MSG_SCAN_REGISTRY";
    private File root;
    private HashMap<String, WorkspaceModel> workspacesFolderRegistry = new HashMap(10);
    private WorkspaceModel currentWorkspace;

    public WorkspacesManager(String wsPath) {
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        log.log((IStatus)new Status(1, this.getClass().getName(), "ROOT_WORKSPACES_FOLDER: " + wsPath));
        this.root = new File(wsPath);
        if (!this.root.exists()) {
            try {
                this.createRoot();
            }
            catch (Exception e) {
                log.log((IStatus)new Status(4, this.getClass().getName(), "creating root foler", (Throwable)e));
            }
        } else {
            this.rebuildWsRegistry();
        }
    }

    public void closeCurrentWorkspace() {
        if (this.currentWorkspace != null) {
            this.currentWorkspace = null;
            this.setChanged();
            this.notifyObservers(MSG_CLOSE_WORKSPACE);
            JdbcResourceManager.closeDriver();
            ClassLoaderFactory.dispose();
            Commons.fireMethodsMapReset();
            RegistryFactory.fireStructuralChangeEvent((StructuralChangeEvent)StructuralChangeEvent.WORKSPACE_CHANGE);
        }
    }

    public void refreshMenuHandlers() {
        this.setChanged();
        this.notifyObservers(MSG_REFRESH_WORKSPACE);
    }

    public WorkspaceModel getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public List<WorkspaceModel> getDeployedWorkspaces() {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        File[] folders = this.root.listFiles();
        if (folders != null) {
            File[] fileArray = folders;
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                File ws_folder = fileArray[n2];
                File wsDesc1 = new File(ws_folder, "ws.xml");
                File wsDesc2 = new File(ws_folder, "ws2.xml");
                if (wsDesc1.exists() && wsDesc1.isFile() || wsDesc2.exists() && wsDesc2.isFile()) {
                    try {
                        res.add(new WorkspaceModelImpl(ws_folder));
                    }
                    catch (Exception e) {
                        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
                        log.log((IStatus)new Status(4, WorkspacesManager.class.getName(), "error get workspace", (Throwable)e));
                    }
                }
                ++n2;
            }
        }
        WorkspacesManager.sortWorkspaceModels(res);
        return res;
    }

    private static void sortWorkspaceModels(List<WorkspaceModel> wsList) {
        Collections.sort(wsList, (e1, e2) -> {
            String o1 = null;
            String o2 = null;
            if (e1.getAcronym().equals(e2.getAcronym())) {
                o2 = e1.getVersion().toString();
                o1 = e2.getVersion().toString();
            } else {
                o1 = e1.getAcronym();
                o2 = e2.getAcronym();
            }
            return o1.compareTo(o2);
        });
    }

    public File getRoot() {
        return this.root;
    }

    public boolean hasCurrentWorkspace() {
        return this.currentWorkspace != null;
    }

    public boolean hasWorkspaceFolderRegistered(String wsPath) {
        return this.workspacesFolderRegistry.containsKey(wsPath);
    }

    public List<WorkspaceModel> getRegisteredWorkspaces(String wsAcronym) {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        Collection<WorkspaceModel> workspaces = this.workspacesFolderRegistry.values();
        for (WorkspaceModel workspaceMetadata : workspaces) {
            if (!workspaceMetadata.getAcronym().equals(wsAcronym)) continue;
            res.add(workspaceMetadata);
        }
        return res;
    }

    public void openWorkspace(String wsPath) throws Exception {
        WorkspaceModel workspaceModel = this.workspacesFolderRegistry.get(wsPath);
        File wsRootFolder = workspaceModel.getWsBaseDir();
        File jarFilePath = new File(String.valueOf(wsRootFolder.getAbsolutePath()) + File.separator + "jar" + File.separator + "fishstatj-jdbc-dao.jar");
        File dbFolderPath = new File(workspaceModel.getWsBaseDir(), "db");
        if (jarFilePath.exists() && dbFolderPath.exists()) {
            Workspace ws = WorkspaceManager.instance().createWorkspace(workspaceModel.getDbUrl(), jarFilePath.toURI().toURL());
            WorkspaceManager.instance().setActiveWorkspace(ws);
        }
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
        log.log((IStatus)new Status(1, this.getClass().getName(), "WS_path=" + workspaceModel.getWsBaseDir() + ", JDBC_URL=" + JdbcResourceManager.getJdbcUrl() + ", JDBC_DRV=" + JdbcResourceManager.getJdbcDriver()));
        this.currentWorkspace = workspaceModel;
        this.setChanged();
        this.notifyObservers(MSG_OPEN_WORKSPACE);
        ReferenceServiceFactory.getService().getConcept("PREDEFINED");
        CoreCommons.getWorkspaceStatus().currentWorkspace = wsPath;
        CoreCommons.getWorkspaceStatus().setStatus(10);
    }

    public void registerWorkspace(String wsPath) throws Exception {
        if (!this.workspacesFolderRegistry.containsKey(wsPath) && this.isWsDescriptorCompatible(wsPath)) {
            WorkspaceModelImpl wmd = new WorkspaceModelImpl(new File(wsPath));
            this.workspacesFolderRegistry.put(wsPath, wmd);
        }
    }

    private boolean isWsDescriptorCompatible(String wsPath) {
        WorkspaceModelImpl wmd = null;
        try {
            wmd = new WorkspaceModelImpl(new File(wsPath));
        }
        catch (Exception exception) {
            return false;
        }
        return wmd.getCompatibility().getMajor() >= CoreCommons.COMPATIBILITY_MAX.getMajor();
    }

    public void switchWorkspace(String wsPath) throws Exception {
        if (this.currentWorkspace != null) {
            this.closeCurrentWorkspace();
        }
        this.openWorkspace(wsPath);
    }

    public List<WorkspaceModel> getWorkspacesByAcronym(String wsAcronym) {
        LinkedList<WorkspaceModel> res = new LinkedList<WorkspaceModel>();
        Collection<WorkspaceModel> workspaces = this.workspacesFolderRegistry.values();
        for (WorkspaceModel workspaceMetadata : workspaces) {
            if (!workspaceMetadata.getAcronym().equals(wsAcronym)) continue;
            res.add(workspaceMetadata);
        }
        return res;
    }

    public boolean isValidWorkspace(WorkspaceModel workspaceMetadata) {
        return this.workspacesFolderRegistry.containsValue(workspaceMetadata);
    }

    public boolean isValidWorkspacePath(String wsPath) {
        if (wsPath == null || wsPath.equals("")) {
            return false;
        }
        if (this.hasWorkspaceFolderRegistered(wsPath)) {
            return true;
        }
        return this.isWsDescriptorCompatible(wsPath);
    }

    public int getNumberOfWorkspaces() {
        return this.workspacesFolderRegistry.size();
    }

    private void createRoot() {
        boolean folderCreated;
        if (!this.root.exists() && (folderCreated = this.root.mkdir())) {
            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
            log.log((IStatus)new Status(1, this.getClass().getName(), "Workspaces root successfully created"));
        }
    }

    protected void rebuildWsRegistry() {
        List<WorkspaceModel> listMetadatas = this.getDeployedWorkspaces();
        this.workspacesFolderRegistry = new HashMap(listMetadatas.size());
        for (WorkspaceModel ws_meta : listMetadatas) {
            this.workspacesFolderRegistry.put(ws_meta.getWsBaseDir().getAbsolutePath(), ws_meta);
        }
        this.setChanged();
        this.notifyObservers(MSG_SCAN_REGISTRY);
    }
}

