/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.generated.workspaces.attachments.Attachments;
import org.fao.fi.fishstat.core.generated.workspaces.attachments.FishstatjAttachments;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Attributes;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Concept;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Concepts;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.FishstatjConcepts;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Relationship;
import org.fao.fi.fishstat.core.generated.workspaces.concepts.Relationships;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.Datasets;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.FishstatjDatasets;
import org.fao.fi.fishstat.core.generated.workspaces.datasets.Timeseries;
import org.fao.fi.fishstat.core.generated.workspaces.workspace.Workspace;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceAdapters;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.osgi.framework.Bundle;

public class WorkspaceStructureExporter {
    public static void exportConcepts(List<Object> elements, String path) throws Exception {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "exportConcepts Method start"));
        FishstatjConcepts fishStatJConcepts = WorkspaceStructureExporter.convertConcepts(elements);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FishstatjConcepts.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)fishStatJConcepts, new File(path));
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "exportConcepts Method end"));
    }

    public static void exportDatasets(List<Object> elements, String path) throws Exception {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "exportDatasets Method start"));
        FishstatjDatasets fishStatJDatasets = WorkspaceStructureExporter.convertDatasets(elements);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FishstatjDatasets.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)fishStatJDatasets, new File(path));
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "exportDatasets Method end"));
    }

    public static void exportAttachments(List<Object> elements, String path) throws Exception {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "exportAttachments Method start"));
        FishstatjAttachments fishstatjAttachments = WorkspaceStructureExporter.convertAttachments(elements);
        FileOutputStream outputStream = new FileOutputStream(path);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{FishstatjAttachments.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        ZipOutputStream out = new ZipOutputStream(outputStream);
        byte[] buf = new byte[1024];
        File[] fileArray = CoreRegistry.getAttachmentsPath().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            int len;
            File attachmentFile = fileArray[n2];
            out.putNextEntry(new ZipEntry(attachmentFile.getName()));
            FileInputStream in = new FileInputStream(attachmentFile);
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            ++n2;
        }
        out.putNextEntry(new ZipEntry("attachments.xml"));
        OutputStreamWriter myout = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
        m.marshal((Object)fishstatjAttachments, (Writer)myout);
        out.close();
        ((Writer)myout).flush();
        ((Writer)myout).close();
        outputStream.flush();
        outputStream.close();
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "exportAttachments Method end"));
    }

    public static FishstatjConcepts convertConcepts(List<Object> elements) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "convertConcepts Method start"));
        FishstatjConcepts fishStatJConcepts = new FishstatjConcepts();
        Concepts xmlConcepts = new Concepts();
        List apiConcepts = ReferenceServiceFactory.getService().getConcepts();
        for (org.fao.fi.fishstat.data.reference.api.Concept apiConcept : apiConcepts) {
            if (CoreCommons.getWorkspaceSystemEntities().isSystemConcept(apiConcept) || elements != null && !elements.contains(apiConcept)) continue;
            Concept xmlConcept = new Concept();
            Attributes xmlAtts = new Attributes();
            xmlConcept.setAcronym(apiConcept.getAcronym());
            if (apiConcept.getSortorder() != null) {
                xmlConcept.setSortOrder(apiConcept.getSortorder());
            }
            xmlConcept.setName(WorkspaceAdapters.ToMutilingual(apiConcept.getName()));
            xmlConcept.setDescription(WorkspaceAdapters.ToMutilingual(apiConcept.getDescription()));
            for (Attribute apiAtt : apiConcept.getAttributes()) {
                org.fao.fi.fishstat.core.generated.workspaces.concepts.Attribute xmlAtt = new org.fao.fi.fishstat.core.generated.workspaces.concepts.Attribute();
                xmlAtt.setIscode(apiAtt.isCodeAttribute());
                xmlAtt.setIsname(apiAtt.isNameAttribute());
                xmlAtt.setScale(Integer.valueOf(apiAtt.getScale()));
                xmlAtt.setSize(Integer.valueOf(apiAtt.getSize()));
                xmlAtt.setType(apiAtt.getType().toString());
                xmlAtt.setAcronym(apiAtt.getAcronym());
                xmlAtt.setName(WorkspaceAdapters.ToMutilingual(apiAtt.getName()));
                xmlAtt.setDescription(WorkspaceAdapters.ToMutilingual(apiAtt.getDescription()));
                xmlAtts.getAttribute().add(xmlAtt);
            }
            xmlConcept.setAttributes(xmlAtts);
            xmlConcepts.getConcept().add(xmlConcept);
        }
        List apiRelationships = ReferenceServiceFactory.getService().getRelationships();
        Relationships xmlRelationships = new Relationships();
        for (org.fao.fi.fishstat.data.reference.api.Relationship apiRelationship : apiRelationships) {
            if (CoreCommons.getWorkspaceSystemEntities().isSystemRelationship(apiRelationship) || elements != null && !elements.contains(apiRelationship)) continue;
            Relationship xmlRelationship = new Relationship();
            xmlRelationship.setAcronym(apiRelationship.getAcronym());
            xmlRelationship.setChild(apiRelationship.getChildConcept().getAcronym());
            xmlRelationship.setParent(apiRelationship.getParentConcept().getAcronym());
            if (apiRelationship.getSortorder() != null) {
                xmlRelationship.setSortOrder(apiRelationship.getSortorder());
            }
            xmlRelationship.setName(WorkspaceAdapters.ToMutilingual(apiRelationship.getName()));
            xmlRelationship.setDescription(WorkspaceAdapters.ToMutilingual(apiRelationship.getDescription()));
            xmlRelationships.getRelationship().add(xmlRelationship);
        }
        fishStatJConcepts.setConcepts(xmlConcepts);
        fishStatJConcepts.setRelationships(xmlRelationships);
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "convertConcepts Method end"));
        return fishStatJConcepts;
    }

    public static FishstatjDatasets convertDatasets(List<Object> elements) throws Exception {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "convertDatasets Method start"));
        FishstatjDatasets fishStatJDatasets = new FishstatjDatasets();
        Datasets xmlDatasets = new Datasets();
        Collection datasets = TimeseriesServiceFactory.getService().getDatasets();
        for (Dataset apiDataset : datasets) {
            if (elements != null && !elements.contains(apiDataset)) continue;
            org.fao.fi.fishstat.core.generated.workspaces.datasets.Dataset xmlDataset = new org.fao.fi.fishstat.core.generated.workspaces.datasets.Dataset();
            xmlDataset.setAcronym(apiDataset.getAcronym());
            xmlDataset.setDatasource(apiDataset.getDataSource().getName());
            xmlDataset.setUrl(apiDataset.getUrl());
            xmlDataset.setVersion(apiDataset.getVersion().getNumber());
            xmlDataset.setAuthor(apiDataset.getVersion().getAuthor());
            try {
                xmlDataset.setDate(new SimpleDateFormat("yyyy-MM-dd").format(apiDataset.getVersion().getDate()));
            }
            catch (Exception exp) {
                exp.printStackTrace();
                xmlDataset.setDate("2014-01-01");
            }
            xmlDataset.setName(WorkspaceAdapters.ToMutilingual(apiDataset.getName()));
            xmlDataset.setDescription(WorkspaceAdapters.ToMutilingual(apiDataset.getDescription()));
            xmlDataset.setCitation(WorkspaceAdapters.ToMutilingual(apiDataset.getCitation()));
            xmlDatasets.getDataset().add(xmlDataset);
            for (Dimension apiDimension : apiDataset.getDimensions()) {
                org.fao.fi.fishstat.core.generated.workspaces.datasets.Dimension xmlDimension = new org.fao.fi.fishstat.core.generated.workspaces.datasets.Dimension();
                xmlDimension.setAcronym(apiDimension.getAcronym());
                xmlDimension.setConcept(apiDimension.getConcept().getAcronym());
                xmlDimension.setAttribute(apiDimension.getAttribute().getAcronym());
                xmlDimension.setIsmeasure(apiDimension.isObservedMeasure());
                xmlDimension.setHasnote(apiDimension.hasNote());
                xmlDimension.setName(WorkspaceAdapters.ToMutilingual(apiDimension.getName()));
                xmlDimension.setDescription(WorkspaceAdapters.ToMutilingual(apiDimension.getDescription()));
                xmlDataset.getDimension().add(xmlDimension);
            }
            for (org.fao.fi.fishstat.data.timeseries.api.Timeseries apiTimeseries : apiDataset.getTimeseries()) {
                Timeseries xmlTimeseries = new Timeseries();
                xmlTimeseries.setAcronym(apiTimeseries.getAcronym());
                xmlTimeseries.setDatasource(apiTimeseries.getDataSource().getName());
                xmlTimeseries.setTimeresolution(apiTimeseries.getTimeResolution().toString());
                xmlTimeseries.setFirstperiod(apiTimeseries.getFirstObservationPeriod().toString());
                xmlTimeseries.setLastperiod(apiTimeseries.getLastObservationPeriod().toString());
                xmlTimeseries.setName(WorkspaceAdapters.ToMutilingual(apiTimeseries.getName()));
                xmlTimeseries.setDescription(WorkspaceAdapters.ToMutilingual(apiTimeseries.getDescription()));
                if (apiTimeseries.getAttributes().size() > 0) {
                    org.fao.fi.fishstat.core.generated.workspaces.datasets.Attributes xmlAttributes = new org.fao.fi.fishstat.core.generated.workspaces.datasets.Attributes();
                    for (org.fao.fi.fishstat.data.timeseries.api.Attribute apiAttribute : apiTimeseries.getAttributes().keySet()) {
                        org.fao.fi.fishstat.core.generated.workspaces.datasets.Attribute xmlAttribute = new org.fao.fi.fishstat.core.generated.workspaces.datasets.Attribute();
                        xmlAttribute.setAcronym(apiAttribute.getAcronym());
                        xmlAttribute.setValue((String)apiTimeseries.getAttributes().get(apiAttribute));
                        xmlAttribute.setName(WorkspaceAdapters.ToMutilingual(apiAttribute.getName()));
                        xmlAttribute.setDescription(WorkspaceAdapters.ToMutilingual(apiAttribute.getDescription()));
                        xmlAttributes.getAttribute().add(xmlAttribute);
                    }
                    xmlTimeseries.setAttributes(xmlAttributes);
                }
                xmlDataset.getTimeseries().add(xmlTimeseries);
            }
        }
        fishStatJDatasets.setDatasets(xmlDatasets);
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "convertDatasets Method end"));
        return fishStatJDatasets;
    }

    public static FishstatjAttachments convertAttachments(List<Object> elements) throws Exception {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "convertAttachments Method start"));
        FishstatjAttachments fishStatJAttachments = new FishstatjAttachments();
        Attachments xmlAttachments = new Attachments();
        LinkedList attachments = new LinkedList();
        for (Dataset dataset : TimeseriesServiceFactory.getService().getDatasets()) {
            attachments.addAll(dataset.getAttachments());
        }
        for (Attachment apiAttachment : attachments) {
            org.fao.fi.fishstat.core.generated.workspaces.attachments.Attachment xmlAttachment = new org.fao.fi.fishstat.core.generated.workspaces.attachments.Attachment();
            xmlAttachment.setAcronym(apiAttachment.getAcronym());
            xmlAttachment.setDataset(apiAttachment.getDataset().getAcronym());
            xmlAttachment.setTypeAttachment(apiAttachment.getType().toString());
            xmlAttachment.setMimeType(apiAttachment.getMimeType());
            xmlAttachment.setName(WorkspaceAdapters.ToMutilingual(apiAttachment.getName()));
            xmlAttachment.setDescription(WorkspaceAdapters.ToMutilingual(apiAttachment.getDescription()));
            xmlAttachment.setFileName(WorkspaceAdapters.ToMutilingual(apiAttachment.getFileName()));
            xmlAttachments.getAttachment().add(xmlAttachment);
        }
        fishStatJAttachments.setAttachments(xmlAttachments);
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime")).log((IStatus)new Status(1, WorkspaceStructureExporter.class.getName(), "convertAttachments Method end"));
        return fishStatJAttachments;
    }

    public static void exportWorkspace(WorkspaceModel currentW4, File descriptor) throws Exception {
        Workspace genW4 = WorkspaceAdapters.convertWorkspace(currentW4);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Workspace.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)genW4, descriptor);
    }
}

