/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api.csv.impl;

import java.util.ArrayList;
import java.util.List;
import org.fao.fi.fishstat.data.common.api.csv.ValidationLevel;
import org.fao.fi.fishstat.data.common.api.csv.ValidationMessage;
import org.fao.fi.fishstat.data.common.api.csv.ValidationResult;
import org.fao.fi.fishstat.data.common.api.csv.impl.ValidationMessageImpl;

public class ValidationResultImpl
implements ValidationResult {
    private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private boolean valid = true;

    public void log(ValidationLevel level, long record, String message) {
        this.messages.add(new ValidationMessageImpl(level, record, message));
        if (!level.isValid()) {
            this.valid = false;
        }
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Override
    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ValidationMessage message : this.messages) {
            builder.append(message.toString()).append("\n");
        }
        return builder.toString();
    }

    @Override
    public void merge(ValidationResult other) {
        this.messages.addAll(other.getMessages());
        this.valid = this.valid && other.isValid();
    }
}

