/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api.daosupport;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.daosupport.exceptions.DAOException;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.ddlutils.DdlUtilsHelper;

public class DAOAdapter
implements GenericDAO {
    private static final String FIND_ALL_METHOD = "findAll";
    private static final String FIND_BY_DYNAMIC_SELECT_METHOD = "findByDynamicSelect";
    private static final String FIND_BY_DYNAMIC_WHERE_METHOD = "findByDynamicWhere";
    private static final String FINDER_PREFIX = "findWhere";
    private static final String FINDER_SUFFIX = "Equals";
    private static final String FIND_BY_ID = "findWhereIdEquals";
    private static final String INSERT_METHOD = "insert";
    private static final String UPDATE_METHOD = "update";
    private static final String DELETE_METHOD = "delete";
    private static final String GET_TABLE_NAME_METHOD = "getTableName";
    private static final String GET_MAX_ROWS_METHOD = "getMaxRows";
    private static final String TRUNCATE_METHOD = "truncate";
    private static final String DELETE_ALL_METHOD = "deleteAll";
    private Object dao;

    public DAOAdapter(Object dao) {
        this.dao = dao;
    }

    @Override
    public int getMaxRows() throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(GET_MAX_ROWS_METHOD, new Class[0]);
            int result = (Integer)method.invoke(this.dao, new Object[0]);
            return result;
        }
        catch (Exception e) {
            throw new DAOException("Unable to call getMaxRows method " + e.getMessage(), e);
        }
    }

    @Override
    public void truncate() throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(TRUNCATE_METHOD, new Class[0]);
            method.invoke(this.dao, new Object[0]);
        }
        catch (Exception e) {
            throw new DAOException("Unable to call truncate method " + e.getMessage(), e);
        }
    }

    @Override
    public void deleteAll() throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(DELETE_ALL_METHOD, new Class[0]);
            method.invoke(this.dao, new Object[0]);
        }
        catch (Exception e) {
            throw new DAOException("Unable to call delete method " + e.getMessage(), e);
        }
    }

    @Override
    public void insert(Object dto) throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(INSERT_METHOD, dto.getClass());
            method.invoke(this.dao, dto);
        }
        catch (Exception e) {
            throw new DAOException("Unable to call insert method " + e.getMessage(), e);
        }
    }

    @Override
    public void update(Object pk, Object dto) throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(UPDATE_METHOD, pk.getClass(), dto.getClass());
            method.invoke(this.dao, pk, dto);
        }
        catch (Exception e) {
            throw new DAOException("Unable to call update method " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(Object pk) throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(DELETE_METHOD, pk.getClass());
            method.invoke(this.dao, pk);
        }
        catch (Exception e) {
            throw new DAOException("Unable to call delete method " + e.getMessage(), e);
        }
    }

    @Override
    public List<Object> findByDynamicSelect(String sql, Object[] sqlParams) throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(FIND_BY_DYNAMIC_SELECT_METHOD, String.class, Object[].class);
            List<Object> result = Arrays.asList((Object[])method.invoke(this.dao, sql, sqlParams));
            return result;
        }
        catch (Exception e) {
            throw new DAOException("Unable to call dynamic select finder method " + e.getMessage(), e);
        }
    }

    @Override
    public List<Object> findByDynamicWhere(String sql, Object[] sqlParams) throws DAOException {
        try {
            Method method = this.dao.getClass().getMethod(FIND_BY_DYNAMIC_WHERE_METHOD, String.class, Object[].class);
            List<Object> result = Arrays.asList((Object[])method.invoke(this.dao, sql, sqlParams));
            return result;
        }
        catch (Exception e) {
            throw new DAOException("Unable to call dynamic where finder method " + e.getMessage(), e);
        }
    }

    @Override
    public List<Object> findByPreparedFinder(String finder, Class<?> clazz, Object arg) throws DAOException {
        try {
            List<Object> result;
            if (clazz == null) {
                Method method = this.dao.getClass().getMethod(finder, new Class[0]);
                result = Arrays.asList((Object[])method.invoke(this.dao, new Object[0]));
            } else {
                Method method = this.dao.getClass().getMethod(finder, clazz);
                result = Arrays.asList((Object[])method.invoke(this.dao, arg));
            }
            return result;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw new DAOException("Illegal argument for the prepared finder method: " + finder + ", found: " + arg + "(" + arg.getClass() + ")" + ", expecting: " + clazz, iae);
        }
        catch (Exception e) {
            throw new DAOException("Unable to call prepared finder method: " + finder, e);
        }
    }

    @Override
    public String generateId() throws DAOException {
        try {
            List<Object> all = this.findAll();
            int max = 0;
            for (Object dto : all) {
                String id = Commons.getDTOIdentifier(dto);
                int int_id = Integer.valueOf(id);
                if (int_id <= max) continue;
                max = int_id;
            }
            return IdentifierHelper.valueOf(max + 1);
        }
        catch (Exception e) {
            throw new DAOException("Unable to generate ID " + e.getMessage(), e);
        }
    }

    @Override
    public int generateIntId() throws DAOException {
        try {
            List<Object> all = this.findAll();
            int max = 0;
            for (Object dto : all) {
                String id = Commons.getDTOIdentifier(dto);
                int int_id = Integer.valueOf(id);
                if (int_id <= max) continue;
                max = int_id;
            }
            return max + 1;
        }
        catch (Exception e) {
            throw new DAOException("Unable to generate ID " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRowCount() throws DAOException {
        try {
            String tableName;
            Connection conn = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                Method method = this.dao.getClass().getMethod(GET_TABLE_NAME_METHOD, new Class[0]);
                tableName = (String)method.invoke(this.dao, new Object[0]);
            }
            catch (Exception e) {
                throw new DAOException("Unable to call getTableName method " + e.getMessage(), e);
            }
            try {
                conn = DdlUtilsHelper.getPlatform().borrowConnection();
                String SQL = "SELECT COUNT(*) FROM " + tableName;
                stmt = conn.prepareStatement(SQL);
                stmt.setMaxRows(1);
                rs = stmt.executeQuery();
                rs.next();
                int n = rs.getInt(1);
                return n;
            }
            catch (Exception _e) {
                throw new Exception("Exception: " + _e.getMessage(), _e);
            }
            finally {
                conn.close();
            }
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }

    @Override
    public List<Object> findAll() throws DAOException {
        return this.findByPreparedFinder(FIND_ALL_METHOD, null, null);
    }

    @Override
    public Object findById(String id) throws DAOException {
        if (id == null) {
            return this.findByDynamicWhere("ID IS NULL", null);
        }
        List<Object> result = this.findByPreparedFinder(FIND_BY_ID, String.class, id);
        if (result != null && result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    @Override
    public List<Object> findByAttribute(String attribute, Class<?> clazz, Object value) throws DAOException {
        if (value == null) {
            return this.findByDynamicWhere(String.valueOf(attribute) + " IS NULL", null);
        }
        return this.findByPreparedFinder(FINDER_PREFIX + Commons.getJavaName(attribute) + FINDER_SUFFIX, clazz, value);
    }
}

