/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.ddlutils;

import javax.sql.DataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformFactory;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;

public class DdlUtilsHelper {
    private static Platform platform;
    private static Database currentModel;
    private static String databaseName;

    public static synchronized Platform getPlatform() throws Exception {
        if (platform == null && JdbcResourceManager.getJdbcDriver().equals("org.apache.derby.jdbc.EmbeddedDriver")) {
            databaseName = JdbcResourceManager.getJdbcUrl().substring(11);
            EmbeddedDataSource dds = new EmbeddedDataSource();
            dds.setDatabaseName(databaseName);
            dds.setUser(JdbcResourceManager.getJdbcUser());
            dds.setPassword(JdbcResourceManager.getJdbcPassword());
            platform = PlatformFactory.createNewPlatformInstance((DataSource)dds);
        }
        return platform;
    }

    public static synchronized Database getDatabase() throws Exception {
        if (currentModel == null) {
            currentModel = DdlUtilsHelper.getPlatform().readModelFromDatabase(databaseName);
        }
        return currentModel;
    }

    public static synchronized Database reloadDatabase() throws Exception {
        currentModel = DdlUtilsHelper.getPlatform().readModelFromDatabase(databaseName);
        return currentModel;
    }

    public static synchronized void dumpDatabase(String filename) throws Exception {
        new DatabaseIO().write(DdlUtilsHelper.getDatabase(), filename);
    }

    public static synchronized void alterDatabase(Database desiredDb) throws Exception {
        DdlUtilsHelper.getPlatform().alterTables(desiredDb, false);
    }
}

