/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.fao.fi.fishstat.data.common.utils.ChannelTools;
import org.fao.fi.fishstat.data.common.utils.IterableEnumeration;

public class JarResources {
    public static void copyResourcesRecursively(URL originUrl, File destination) throws IOException {
        URLConnection urlConnection = originUrl.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            JarResources.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
        } else if (originUrl.getProtocol().equals("file")) {
            FileUtils.copyDirectoryToDirectory((File)new File(originUrl.getPath()), (File)destination);
        } else {
            throw new IOException("URLConnection[" + urlConnection.getClass().getSimpleName() + "] is not a recognized/implemented connection type.");
        }
    }

    public static void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        for (JarEntry entry : IterableEnumeration.make(jarFile.entries())) {
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = entry.getName();
            if (!entry.isDirectory()) {
                FileOutputStream entryOutputStream = null;
                try (InputStream entryInputStream = null;){
                    entryInputStream = jarFile.getInputStream(entry);
                    entryOutputStream = new FileOutputStream(new File(destination, fileName));
                    ReadableByteChannel inputChannel = Channels.newChannel(entryInputStream);
                    WritableByteChannel outputChannel = Channels.newChannel(entryOutputStream);
                    ChannelTools.fastChannelCopy(inputChannel, outputChannel);
                    inputChannel.close();
                    outputChannel.close();
                    continue;
                }
            }
            new File(destination, fileName).mkdirs();
        }
    }
}

