/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class DimensionRelationsComboViewer
extends ComboViewer {
    private Concept concept = null;
    private String lang;

    public DimensionRelationsComboViewer(Composite dimension, int style, Concept c, String lang) {
        super(dimension, 0x10000000 | style);
        this.lang = lang;
        this.concept = c;
        this.setContentProvider((IContentProvider)new RelationsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DimensionParentsLabelProvider(this.lang));
        this.setComparator(new DimensionParentsSorter(this.lang));
        this.setInput(c);
        if (c != null && this.getCombo().getItemCount() > 0) {
            this.setSelection((ISelection)new StructuredSelection(this.getElementAt(0)));
        }
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        this.setInput(concept);
        this.getCombo().redraw();
        this.setSelection((ISelection)new StructuredSelection(this.getElementAt(0)));
    }

    public Relationship getSelectedRelation() {
        return (Relationship)((StructuredSelection)this.getSelection()).getFirstElement();
    }

    private class DimensionParentsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private String lang;

        public DimensionParentsLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Relationship) {
                return CoreUtils.getCurrentLangName((Object)element, (String)this.lang);
            }
            if (element instanceof Concept) {
                return CoreUtils.getCurrentLangName((Object)element, (String)this.lang);
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "#ERROR#";
        }
    }

    private class DimensionParentsSorter
    extends ViewerComparator {
        private String lang;

        public DimensionParentsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Relationship && e2 instanceof Relationship) {
                if (((Relationship)e1).getParentConcept().getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                if (((Relationship)e2).getParentConcept().getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                if (((Relationship)e1).getSortorder() == null || ((Relationship)e2).getSortorder() == null) {
                    return CoreUtils.getCurrentLangName((Object)((Relationship)e1), (String)this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Relationship)e2), (String)this.lang));
                }
                return ((Relationship)e1).getSortorder().compareTo(((Relationship)e2).getSortorder());
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class RelationsContentProvider
    implements IStructuredContentProvider {
        private RelationsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                return DimensionRelationsComboViewer.this.concept.getParentRelationships().toArray(new Relationship[0]);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

