/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class ConceptAttributesComboViewer
extends ComboViewer {
    private String lang;

    public ConceptAttributesComboViewer(Composite composite, int style, String lang) {
        super(composite, 0x10000000 | style);
        this.lang = lang;
        this.setContentProvider((IContentProvider)new ConceptFieldsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ConceptFieldsLabelProvider(this.lang));
        this.setComparator(new ConceptFieldsSorter(this.lang));
    }

    public Relationship getSelectedRelation() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Relationship)sel.getFirstElement();
    }

    private class ConceptFieldsContentProvider
    implements IStructuredContentProvider {
        private ConceptFieldsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            block5: {
                if (inputElement == null) {
                    return new Object[0];
                }
                if (inputElement instanceof Concept) {
                    try {
                        Collection attributes = ((Concept)inputElement).getAttributes();
                        LinkedList<Attribute> res = new LinkedList<Attribute>();
                        for (Attribute attribute : attributes) {
                            if (attribute.getAcronym().equals("ID")) continue;
                            res.add(attribute);
                        }
                        return res.toArray(new Attribute[0]);
                    }
                    catch (ReferenceServiceException e) {
                        ComponentsCommons.showExceptionWithStack(e);
                        if (ConceptAttributesComboViewer.this.getCombo().getItemCount() <= 0) break block5;
                        ConceptAttributesComboViewer.this.setSelection((ISelection)new StructuredSelection(ConceptAttributesComboViewer.this.getElementAt(0)));
                    }
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ConceptFieldsLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private String lang;

        public ConceptFieldsLabelProvider(String lang) {
            this.lang = lang;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public String getText(Object element) {
            if (element instanceof Attribute) {
                return CoreUtils.getCurrentLangName((Object)((Attribute)element), (String)this.lang);
            }
            return null;
        }
    }

    private class ConceptFieldsSorter
    extends ViewerComparator {
        private String lang;

        public ConceptFieldsSorter(String lang) {
            this.lang = lang;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Concept) {
                Concept c1 = (Concept)e1;
                if (c1.getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                Concept c2 = (Concept)e2;
                if (c2.getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                return CoreUtils.getCurrentLangName((Object)c1, (String)this.lang).compareTo(CoreUtils.getCurrentLangName((Object)c2, (String)this.lang));
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

