/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.autoupdate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.autoupdate.AutoUpdateMain;
import org.fao.fi.fishstat.gui.autoupdate.AutoupdateUtil;

public class DownloadFile {
    private static int TIMEOUT_CONNECT = 30;
    private static int TIMEOUT_REQUEST = 45;
    private static int RETRY_COUNT = 6;
    private static int RETRY_DELAY = 15;
    private static int DOWNLOAD_MINSIZE = 200000;
    private static int DOWNLOAD_BLOCKSIZE = 30000;
    private static String HTTP_CONTENT_LENGTH = "content-length";
    private static String HTTP_USER_AGENT = "User-Agent";
    private String user_agent = "FishStatJ v" + AutoupdateUtil.getCurrentVersion().toString() + " " + System.getProperty("os.name");
    private String httpURL;
    private String downloadFile;
    private long totalDownload = 0L;
    private int consumedTicks = 0;
    private boolean status = false;
    boolean proxy_isActivated = false;
    boolean proxy_isAuthenticated = false;
    private String proxy_server;
    private int proxy_port;
    private String encoded;

    public DownloadFile(String httpURL) {
        this.httpURL = httpURL;
        this.totalDownload = this.getContentLength(httpURL.replaceAll(" ", "%20"));
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.proxy_isActivated = ps.getBoolean("proxy.acticated");
        this.proxy_server = ps.getString("proxy.server.ip");
        this.proxy_port = ps.getInt("proxy.server.port");
        String proxy_user = ps.getString("proxy.server.user");
        String proxy_pass = ps.getString("proxy.server.password");
        if (this.proxy_isActivated && !proxy_user.isEmpty() && !proxy_pass.isEmpty()) {
            this.proxy_isAuthenticated = true;
            this.encoded = new String(Base64.getEncoder().encode((String.valueOf(proxy_user) + ":" + proxy_pass).getBytes()));
        }
    }

    public boolean doDownload(String optionalPath) {
        String downloadFolder = optionalPath != null ? optionalPath : Activator.getDefault().getPreferenceStore().getString("workspace.download.folder");
        File downloadFodler = new File(downloadFolder);
        if (!downloadFodler.exists() || !downloadFodler.isDirectory()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Activator.getPluginBundle().getString("workspaces.installing.invalidfolder.title"), (String)(String.valueOf(downloadFolder) + "\n\n" + Activator.getPluginBundle().getString("workspaces.installing.invalidfolder.message")));
            return false;
        }
        this.downloadFile = this.httpURL.substring(this.httpURL.lastIndexOf(47) + 1);
        final String downloadPath = String.valueOf(downloadFolder) + File.separator + this.downloadFile;
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            progress.setCancelable(false);
            progress.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        DownloadFile.this.status = DownloadFile.this.doDownload2(downloadPath, monitor);
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), e.getMessage()));
                    }
                }
            });
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), e.getMessage()));
        }
        return this.status;
    }

    public boolean doDownload2(String filePath, IProgressMonitor monitor) {
        if (this.totalDownload == 0L) {
            return false;
        }
        monitor.beginTask(this.httpURL, (int)(this.totalDownload / (long)DOWNLOAD_BLOCKSIZE));
        int retry = 0;
        while (retry < RETRY_COUNT) {
            if (retry > 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), "---------- download retry #" + retry + " file=" + this.getFileSize(filePath)));
                try {
                    TimeUnit.SECONDS.sleep(RETRY_DELAY);
                }
                catch (Exception exception) {}
            }
            if (this.downloadFile(this.httpURL.replaceAll(" ", "%20"), filePath, monitor, retry)) {
                if (monitor != null) {
                    monitor.done();
                }
                return true;
            }
            ++retry;
        }
        if (monitor != null) {
            monitor.done();
        }
        return false;
    }

    private long getContentLength(String downloadURL) {
        try {
            HttpClient client;
            HttpResponse<Void> response;
            HttpHeaders headers;
            List<String> val;
            HttpRequest.Builder reqBuilder = HttpRequest.newBuilder();
            reqBuilder.uri(URI.create(downloadURL));
            reqBuilder.headers(HTTP_USER_AGENT, this.user_agent);
            if (this.proxy_isAuthenticated) {
                reqBuilder.headers("Proxy-Authorization", "Basic " + this.encoded);
            }
            reqBuilder.timeout(Duration.ofSeconds(TIMEOUT_REQUEST));
            reqBuilder.method("HEAD", HttpRequest.BodyPublishers.noBody());
            HttpRequest request = reqBuilder.build();
            HttpClient.Builder cliBuilder = HttpClient.newBuilder();
            cliBuilder.connectTimeout(Duration.ofSeconds(TIMEOUT_CONNECT));
            cliBuilder.followRedirects(HttpClient.Redirect.ALWAYS);
            if (this.proxy_isActivated) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, AutoUpdateMain.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.proxy"), this.proxy_server, this.proxy_port)));
                cliBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxy_server, this.proxy_port)));
            }
            if (!(val = (headers = (response = (client = cliBuilder.build()).send(request, HttpResponse.BodyHandlers.discarding())).headers()).allValues(HTTP_CONTENT_LENGTH)).isEmpty()) {
                return Long.parseLong(val.get(0));
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfile"), downloadURL), (Throwable)e));
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean downloadFile(String downloadURL, String filepath, IProgressMonitor monitor, int retry) {
        try {
            block27: {
                HttpClient client;
                HttpResponse<InputStream> response;
                int statusCode;
                long downloadSoFar = this.getFileSize(filepath);
                if (downloadSoFar > this.totalDownload) {
                    downloadSoFar = 0L;
                }
                if (downloadSoFar == this.totalDownload) {
                    Activator.getDefault().getLog().log((IStatus)new Status(0, AutoupdateUtil.class.getName(), "already downloaded: " + filepath));
                    return true;
                }
                if (downloadSoFar / (long)DOWNLOAD_BLOCKSIZE > (long)this.consumedTicks) {
                    int consumeNow = (int)(downloadSoFar / (long)DOWNLOAD_BLOCKSIZE - (long)this.consumedTicks);
                    if (monitor != null) {
                        monitor.worked(consumeNow);
                    }
                    this.consumedTicks += consumeNow;
                }
                HttpRequest.Builder reqBuilder = HttpRequest.newBuilder();
                reqBuilder.uri(URI.create(downloadURL));
                reqBuilder.headers(HTTP_USER_AGENT, this.user_agent);
                if (this.proxy_isAuthenticated) {
                    reqBuilder.headers("Proxy-Authorization", "Basic " + this.encoded);
                }
                reqBuilder.timeout(Duration.ofSeconds(TIMEOUT_REQUEST));
                reqBuilder.GET();
                if (downloadSoFar > 0L) {
                    reqBuilder.header("Range", "bytes=" + downloadSoFar + "-");
                    Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), "resuming download at offset " + downloadSoFar));
                }
                HttpRequest request = reqBuilder.build();
                HttpClient.Builder cliBuilder = HttpClient.newBuilder();
                cliBuilder.connectTimeout(Duration.ofSeconds(TIMEOUT_CONNECT));
                cliBuilder.followRedirects(HttpClient.Redirect.ALWAYS);
                if (this.proxy_isActivated) {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, AutoUpdateMain.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.proxy"), this.proxy_server, this.proxy_port)));
                    cliBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxy_server, this.proxy_port)));
                }
                if ((statusCode = (response = (client = cliBuilder.build()).send(request, HttpResponse.BodyHandlers.ofInputStream())).statusCode()) != 200 && statusCode != 206) {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, AutoupdateUtil.class.getName(), "abort; received status code= " + statusCode + ", " + downloadURL));
                    return false;
                }
                try {
                    Throwable throwable = null;
                    Object var14_17 = null;
                    try {
                        InputStream in = response.body();
                        try {
                            try (FileOutputStream fos = new FileOutputStream(filepath, downloadSoFar > 0L);){
                                int bytesRead = -1;
                                byte[] buffer = new byte[DOWNLOAD_BLOCKSIZE];
                                while ((bytesRead = in.read(buffer)) != -1) {
                                    fos.write(buffer, 0, bytesRead);
                                    if ((downloadSoFar += (long)bytesRead) / (long)DOWNLOAD_BLOCKSIZE <= (long)this.consumedTicks) continue;
                                    if (monitor != null) {
                                        monitor.worked(1);
                                    }
                                    ++this.consumedTicks;
                                }
                            }
                            if (in == null) break block27;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, AutoupdateUtil.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfile"), downloadURL), (Throwable)e));
                    return false;
                }
            }
            Activator.getDefault().getLog().log((IStatus)new Status(0, AutoupdateUtil.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.downloadok"), downloadURL)));
            return true;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, AutoupdateUtil.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfile"), downloadURL), (Throwable)e));
            return false;
        }
    }

    private long getFileSize(String filepath) {
        long size;
        block5: {
            Path path;
            block4: {
                try {
                    path = Path.of(filepath, new String[0]);
                    if (Files.exists(path, new LinkOption[0])) break block4;
                    return 0L;
                }
                catch (Exception exception) {
                    return 0L;
                }
            }
            size = Files.size(path);
            if (size >= (long)DOWNLOAD_MINSIZE) break block5;
            return 0L;
        }
        return size;
    }

    public Object getDownloadFile() {
        return this.downloadFile;
    }

    public String GetDownloadString() {
        HttpResponse<String> response;
        block5: {
            try {
                HttpClient client;
                int statusCode;
                HttpRequest.Builder reqBuilder = HttpRequest.newBuilder();
                reqBuilder.uri(URI.create(this.httpURL));
                reqBuilder.headers(HTTP_USER_AGENT, this.user_agent);
                if (this.proxy_isAuthenticated) {
                    reqBuilder.headers("Proxy-Authorization", "Basic " + this.encoded);
                }
                reqBuilder.timeout(Duration.ofSeconds(TIMEOUT_REQUEST));
                reqBuilder.GET();
                HttpRequest request = reqBuilder.build();
                HttpClient.Builder cliBuilder = HttpClient.newBuilder();
                cliBuilder.connectTimeout(Duration.ofSeconds(TIMEOUT_CONNECT));
                cliBuilder.followRedirects(HttpClient.Redirect.ALWAYS);
                if (this.proxy_isActivated) {
                    Activator.getDefault().getLog().log((IStatus)new Status(1, AutoUpdateMain.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.proxy"), this.proxy_server, this.proxy_port)));
                    cliBuilder.proxy(ProxySelector.of(new InetSocketAddress(this.proxy_server, this.proxy_port)));
                }
                if ((statusCode = (response = (client = cliBuilder.build()).send(request, HttpResponse.BodyHandlers.ofString())).statusCode()) == 200 || statusCode == 206) break block5;
                Activator.getDefault().getLog().log((IStatus)new Status(1, AutoupdateUtil.class.getName(), "abort; received status code= " + statusCode + ", " + this.httpURL));
                return null;
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(1, AutoupdateUtil.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfile"), this.httpURL), (Throwable)e));
                return null;
            }
        }
        return response.body().toString();
    }
}

