/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.aggregation;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupsDaoFactory;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptParentsComboViewer;
import org.fao.fi.fishstat.gui.dataset.aggregation.HandpickedAggregationDialog;

public class DimensionAggregationComposite {
    private DimensionAggregation aggregation;
    private List cmbAggTypes;
    private Button chkHandpicked;
    private Button butHandpicked;
    private Combo cmbConcepts;
    private ConceptParentsComboViewer lstConcepts;

    public DimensionAggregationComposite(Composite parent, DimensionAggregation a) {
        this.aggregation = a;
        this.initComponents(new Group(parent, 0));
        parent.pack();
    }

    private void initComponents(Group layoutGroup) {
        layoutGroup.setForeground(SWTResourceManager.getColor(255, 255, 255));
        layoutGroup.setBackground(SWTResourceManager.getColor(250, 250, 250));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 7;
        gridLayout.horizontalSpacing = 20;
        gridLayout.marginBottom = 5;
        gridLayout.marginLeft = 10;
        layoutGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.verticalAlignment = 128;
        gridData.grabExcessHorizontalSpace = true;
        gridData.minimumWidth = 450;
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        layoutGroup.setLayoutData((Object)gridData);
        Label label = new Label((Composite)layoutGroup, 0);
        label.setFont(SWTResourceManager.getFont("Tahoma", 8, 1));
        label.setForeground(SWTResourceManager.getColor(41, 98, 183));
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        label.setText(CoreUtils.getCurrentLangName((Object)this.aggregation.getDimension(), (String)Activator.getLanguage()));
        this.cmbAggTypes = new List((Composite)layoutGroup, 0);
        this.cmbAggTypes.setBackground(Display.getCurrent().getSystemColor(25));
        this.cmbAggTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionAggregationComposite.this.applyData();
                DimensionAggregationComposite.this.redesignPanel();
            }
        });
        GridData gdcmbAggTypes = new GridData(0, 4, false, true, 1, 2);
        this.cmbAggTypes.setLayoutData((Object)gdcmbAggTypes);
        this.chkHandpicked = new Button((Composite)layoutGroup, 32);
        this.chkHandpicked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionAggregationComposite.this.applyData();
                DimensionAggregationComposite.this.redesignPanel();
            }
        });
        this.chkHandpicked.setText(Activator.getLocalString("label.handpicked.first.upper"));
        this.butHandpicked = new Button((Composite)layoutGroup, 0);
        this.butHandpicked.setAlignment(16384);
        this.butHandpicked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandpickedAggregationDialog dlg = new HandpickedAggregationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DimensionAggregationComposite.this.aggregation);
                dlg.open();
            }
        });
        this.butHandpicked.setImage(Activator.getImage("icons/actions/hand.png"));
        this.butHandpicked.setEnabled(false);
        this.butHandpicked.setSize(50, 50);
        GridData gdButHandpicked = new GridData(0, 0, false, true, 1, 2);
        this.butHandpicked.setLayoutData((Object)gdButHandpicked);
        this.lstConcepts = new ConceptParentsComboViewer((Composite)layoutGroup, 0, Activator.getLanguage(), false);
        this.lstConcepts.setCustomGroupsIncluded(CustomGroupsDaoFactory.create().size(this.aggregation.getDimension().getAcronym()) > 0);
        this.lstConcepts.setInput((Object)this.aggregation.getDimension().getConcept());
        this.cmbConcepts = this.lstConcepts.getCombo();
        if (this.cmbConcepts.getItemCount() > 0) {
            this.lstConcepts.setSelection((ISelection)new StructuredSelection(this.lstConcepts.getElementAt(0)));
            this.lstConcepts.addSelectionChangedListener(event -> {
                this.applyData();
                this.redesignPanel();
            });
        }
        this.cmbConcepts.setEnabled(false);
        this.cmbAggTypes.add(Activator.getLocalString("label.detailed.first.upper"));
        if (this.cmbConcepts.getItemCount() > 0) {
            this.cmbAggTypes.add(Activator.getLocalString("label.grouped.first.upper"));
        }
        this.cmbAggTypes.add(Activator.getLocalString("label.aggregated.first.upper"));
        this.cmbAggTypes.select(0);
        this.syncroCombos();
        this.redesignPanel();
    }

    private void syncroCombos() {
        switch (this.aggregation.getType()) {
            case 0: {
                this.cmbAggTypes.select(0);
                break;
            }
            case 1: {
                this.cmbAggTypes.select(1);
                this.lstConcepts.setSelection((ISelection)new StructuredSelection((Object)this.aggregation.getBasicAggregator()), true);
                break;
            }
            case 2: {
                this.cmbAggTypes.select(1);
                break;
            }
            case 3: {
                this.cmbAggTypes.select(this.cmbAggTypes.getItemCount() - 1);
                break;
            }
        }
    }

    private void redesignPanel() {
        switch (this.aggregation.getType()) {
            case 0: {
                this.lstConcepts.getCombo().setEnabled(false);
                this.chkHandpicked.setEnabled(false);
                this.butHandpicked.setEnabled(false);
                break;
            }
            case 1: {
                this.chkHandpicked.setEnabled(true);
                this.chkHandpicked.setSelection(false);
                this.lstConcepts.getCombo().setEnabled(true);
                this.lstConcepts.getCombo().setEnabled(true);
                this.butHandpicked.setEnabled(false);
                break;
            }
            case 2: {
                this.chkHandpicked.setEnabled(true);
                this.chkHandpicked.setSelection(true);
                this.lstConcepts.getCombo().setEnabled(true);
                this.lstConcepts.getCombo().setEnabled(false);
                this.butHandpicked.setEnabled(true);
                break;
            }
            case 3: {
                this.chkHandpicked.setEnabled(false);
                this.lstConcepts.getCombo().setEnabled(false);
                this.butHandpicked.setEnabled(false);
                break;
            }
        }
    }

    protected void applyData() {
        int sel = this.cmbAggTypes.getSelectionIndex();
        switch (sel) {
            case 0: {
                this.aggregation.setDetailedDimension();
                break;
            }
            case 1: {
                if (this.cmbConcepts.getItemCount() > 0) {
                    this.adjournHandPicked();
                    break;
                }
                this.aggregation.setAggregatedDimension();
                break;
            }
            case 2: {
                this.aggregation.setAggregatedDimension();
                break;
            }
        }
    }

    private void adjournHandPicked() {
        if (this.chkHandpicked.getSelection()) {
            this.aggregation.setHandPickedAggregation();
        } else {
            Concept concept = (Concept)((IStructuredSelection)this.lstConcepts.getSelection()).getFirstElement();
            if (concept != null) {
                this.aggregation.setBasicConceptAggregation(concept);
            }
        }
    }
}

