/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.edit;

import java.io.StringWriter;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.export.CsvViewExporter;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettingsDialog;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class SeriesCopyHandler
extends AbstractHandlerWorkspaces {
    public static final String ID = "org.fao.fi.fishstat.gui.command.edit.csv.copy.details";
    private IPreferenceStore ps = Activator.getDefault().getPreferenceStore();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ExportSettingsDialog dialog;
        int result;
        ExportSettings exportSettings = new ExportSettings(this.ps);
        Shell active = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (active.getText().equals("Metadata")) {
            this.metadataCopyHandler(active.getChildren(), exportSettings);
            return null;
        }
        MultiTableView currentView = (MultiTableView)ApplicationWorkbenchAdvisor.getApplicationAdvisor().getLastActiveDoubleTableView();
        if (currentView == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "currentView is null"));
            return null;
        }
        if (currentView.getSession() == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "currentView has no session"));
            return null;
        }
        if (this.ps.getBoolean("export.csv.askconfirm") && (result = (dialog = new ExportSettingsDialog(Activator.getDefault().getWorkbench().getDisplay().getActiveShell(), exportSettings)).open()) == 1) {
            return null;
        }
        CsvViewExporter exporter = new CsvViewExporter(currentView, exportSettings);
        exporter.setSeparator(Character.valueOf('\t'));
        exporter.setWriter(new StringWriter());
        if (exporter.hasEmptySelection()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getLocalString("label.export.copy.nothing.title"), (String)Activator.getLocalString("label.export.copy.nothing.message"));
            exporter.close();
            return null;
        }
        if (exporter.getExportSize() > 1000) {
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, true, (IRunnableWithProgress)exporter);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "large copy data export", (Throwable)e));
            }
        } else {
            try {
                exporter.run(null);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), "small copy data export", (Throwable)e));
            }
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Clipboard clipboard = new Clipboard(Display.getDefault());
        clipboard.setContents(new Object[]{((StringWriter)exporter.getWriter()).getBuffer().toString()}, new Transfer[]{textTransfer});
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getLocalString("label.export.copy.done.title"), (String)MessageFormat.format(Activator.getLocalString("label.export.copy.done.message"), exporter.getExportSize()));
        }
        exporter.close();
        return null;
    }

    private void metadataCopyHandler(Control[] controls, ExportSettings exportSettings) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.metadataCopyHandler(((Composite)control).getChildren(), exportSettings);
            }
            ++n2;
        }
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && !GuiCoreActivator.getDefault().getRegistry().getOpenSessions().isEmpty());
    }
}

