/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;

public class MultiSortElemProperties
implements Cloneable {
    protected MultiSortProperties sortProperties;
    private boolean active;
    private char type;
    private Dimension dimension;
    private int dimensionIdx;
    private Concept concept;
    private Attribute attribute;
    private ObservationPeriod observationPeriod;
    private boolean ascending;

    public MultiSortElemProperties(MultiSortProperties p) {
        this.sortProperties = p;
        this.active = false;
    }

    public MultiSortElemProperties(MultiSortProperties p, Dimension d) {
        this.sortProperties = p;
        this.createDefaults(p.getTimeSeriesProperties().getPreferenceStore(), d);
    }

    public MultiSortProperties getProperties() {
        return this.sortProperties;
    }

    public Timeseries getTimeseries() {
        return this.sortProperties.getTimeseries();
    }

    public char getType() {
        return this.type;
    }

    public void setType(char type) {
        this.type = type;
        if (type == 'D') {
            this.observationPeriod = null;
        } else {
            this.dimension = null;
            this.concept = null;
            this.attribute = null;
        }
        this.sortProperties.setChanged();
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
        try {
            this.dimensionIdx = this.sortProperties.getDataset().getDimensions().indexOf(dimension);
        }
        catch (TimeseriesServiceException e) {
            e.printStackTrace();
        }
        this.sortProperties.setChanged();
    }

    public int getDimensionIdx() {
        return this.dimensionIdx;
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        this.sortProperties.setChanged();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
        this.sortProperties.setChanged();
    }

    public ObservationPeriod getObservationPeriod() {
        return this.observationPeriod;
    }

    public void setObservationPeriod(ObservationPeriod observationPeriod) {
        this.observationPeriod = observationPeriod;
        this.sortProperties.setChanged();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
        this.sortProperties.setChanged();
    }

    private void createDefaults(PreferenceStore store, Dimension d) {
        this.active = true;
        this.type = (char)68;
        this.setDimension(d);
        this.setConcept(d.getConcept());
        this.setAttribute(d.getConcept().getNameAttribute());
        this.ascending = true;
    }

    protected String marshal() {
        StringBuffer res = new StringBuffer();
        if (this.type == 'D') {
            res.append(this.dimension.getAcronym());
            res.append(",");
            res.append(this.concept.getAcronym());
            res.append(",");
            res.append(this.attribute.getAcronym());
            res.append(",");
        } else {
            res.append(this.observationPeriod.toString());
            res.append(",");
        }
        res.append(this.ascending ? "ASC" : "DES");
        return res.toString();
    }

    protected void unmarshal(String message) {
        String[] parts = message.split(",");
        this.type = (char)(parts.length == 4 ? 68 : 83);
        if (this.type == 'D') {
            this.setDimension(this.sortProperties.getTimeSeriesProperties().getTimeseries().getDataset().getDimension(parts[0]));
            this.setConcept(CoreUtils.getConcept((String)parts[1]));
            this.setAttribute(CoreUtils.getConceptAttribute((Concept)this.concept, (String)parts[2]));
            this.ascending = parts[3].equals("ASC");
        } else {
            this.setObservationPeriod(new ObservationPeriod(parts[0]));
            this.ascending = parts[1].equals("ASC");
        }
        this.active = true;
    }

    protected MultiSortElemProperties clone() {
        MultiSortElemProperties res = new MultiSortElemProperties(this.sortProperties);
        res.active = this.active;
        res.ascending = this.ascending;
        res.attribute = this.attribute;
        res.concept = this.concept;
        res.dimension = this.dimension;
        res.dimensionIdx = this.dimensionIdx;
        res.observationPeriod = this.observationPeriod;
        res.sortProperties = this.sortProperties;
        res.type = this.type;
        return res;
    }
}

