/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.StatUtils;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Descriptive;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.FunctionBase;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;

public class HarmonicMean
extends FunctionBase
implements Descriptive {
    public HarmonicMean() {
    }

    public HarmonicMean(ReferenceObject function) {
        super(function);
    }

    @Override
    public double evaluate(List<Double> values, Map<Parameter, String> parameters) {
        int n = values.size();
        if (n == 0) {
            return 0.0;
        }
        double[] reciprocals = new double[n];
        int i = 0;
        while (i < values.size()) {
            double value = values.get(i);
            if (value == 0.0) {
                return 0.0;
            }
            reciprocals[i] = 1.0 / value;
            ++i;
        }
        return StatUtils.sum((double[])reciprocals);
    }
}

