/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.Collection;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ReferencedMeasuresTestCase {
    private static final long REFERENCED_MEASURES_MAX_TIME = 1000L;

    @BeforeClass
    public static void setUpClass() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testGetReferencedMeasures() throws Exception {
        Timeseries aquaculture = TimeseriesServiceFactory.getService().getDataset("GLOBAL_AQUACULTURE").getTimeseries("PRODUCTION");
        aquaculture.getObservations();
        Timer.start();
        Dimension measure_dimension = aquaculture.getDataset().getObservedMeasureDimension();
        Collection<ReferenceObject> measures = aquaculture.getReferencedObjects(aquaculture.getDataset().getObservedMeasureDimension());
        Timer.stop();
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to get referenced measures"), (Timer.timeElapsed() < 1000L ? 1 : 0) != 0);
        Assert.assertTrue((String)("Got " + measures.size() + " referenced measures"), (measures.size() == 2 ? 1 : 0) != 0);
        System.out.println("Referenced measures:");
        for (ReferenceObject m1 : measures) {
            System.out.println(m1);
        }
        Selection selection = Selection.instance();
        Concept measure_concept = measure_dimension.getConcept();
        ReferenceObject only_quantity = measure_concept.getObject("CODE", (Object)"V_USD_1000");
        selection.add(measure_concept, only_quantity);
        System.out.println("filetring on value observations...");
        aquaculture.filter(selection);
        measures = aquaculture.getReferencedObjects(measure_dimension);
        Assert.assertTrue((String)("Got " + measures.size() + " referenced measures"), (measures.size() == 1 ? 1 : 0) != 0);
        for (ReferenceObject m2 : measures) {
            System.out.println(m2);
        }
    }
}

