/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.test;

import java.util.Collection;
import java.util.List;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.RuntimeMemory;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroup;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeseriesTestCase {
    private static final int GET_OBSERVATIONS_MAX_TIME = 35000;
    private static final int AGGREGATE_ALL_MAX_TIME = 18000;
    private static final int GROUP_BY_CONTINENT_MAX_TIME = 6500;
    private static final int GROUP_BY_COUNTRY_MAX_TIME = 9000;
    private static final long TOP_OTHERS_MAX_TIME = 15000L;
    private static final long ROW_COUNT_MAX_TIME = 1500L;
    private static final long TOTALS_MAX_TIME = 3000L;
    private static final long SORT_MAX_TIME = 5000L;
    private static final long CUSTOM_GROUPS_MAX_TIME = 4500L;
    private static Dataset production;
    private static Timeseries production_quantity;

    @BeforeClass
    public static void setUpClass() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        production = TimeseriesServiceFactory.getService().getDataset("GLOBAL_PRODUCTION");
        production_quantity = production.getTimeseries("QUANTITY");
    }

    @Before
    public void setUpTest() throws Exception {
        production_quantity.reset();
        System.out.println("getting observations...");
        Timer.start();
        production_quantity.getObservations();
        Timer.stop();
        System.out.println("ready in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testRowCount() throws Exception {
        Timer.start();
        long rowcount = production_quantity.getRowCount();
        Timer.stop();
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to get row count"), (Timer.timeElapsed() < 1500L ? 1 : 0) != 0);
        System.out.println("RowCount: " + rowcount + " in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testCustomGroups() throws Exception {
        Timer.start();
        for (Dimension dimension : production.getDimensions()) {
            System.out.println(dimension.getName());
            Concept concept = dimension.getConcept();
            concept.getObjects();
            for (CustomGroup group : CustomGroupFactory.get((Concept)concept)) {
                System.out.println(String.valueOf('\t') + group.getName().toString());
                group.getMembers();
            }
        }
        Timer.stop();
        System.out.println("found custom groups in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to get custom groups"), (Timer.timeElapsed() < 4500L ? 1 : 0) != 0);
    }

    @Test
    public void testGetLocalCodeList() throws Exception {
        Timer.start();
        Collection<ReferenceObject> result = production_quantity.getAllReferencedObjects(production.getDimension("SPECIES"));
        Timer.stop();
        System.out.println("found " + result.size() + " codes in " + Timer.timeElapsed() + "msec");
    }

    @Test
    public void testAggregateAll() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        Concept area = ReferenceServiceFactory.getService().getConcept("AREA");
        ReferenceObject all = ReferenceObject.ALL;
        selection.add(country, all);
        selection.add(species, all);
        selection.add(area, all);
        System.out.println("aggregating all...");
        Timer.start();
        production_quantity.aggregate(selection);
        Timer.stop();
        System.out.println("found: " + production_quantity.getObservations().size());
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to aggregate all"), (Timer.timeElapsed() < 18000L ? 1 : 0) != 0);
    }

    @Test
    public void testGetObservations() throws Exception {
        production_quantity.reset();
        System.out.println("loading observations...");
        Timer.start();
        List<ObservationSeries> result = production_quantity.getObservations();
        Timer.stop();
        System.out.println("loaded " + result.size() + " observations in " + Timer.timeElapsed() + "msec (" + (long)result.size() / (Timer.timeElapsed() / 1000L) + "obs/sec)");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to get the observations"), (Timer.timeElapsed() < 35000L ? 1 : 0) != 0);
    }

    @Test
    public void testRepeatedFilter() throws Exception {
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("CONTINENT_COUNTRY");
        for (ReferenceObject c : continent.getObjects()) {
            System.out.println("filetring on " + c);
            Selection selection = Selection.instance();
            selection.addAll(country, relationship.getChildren(c));
            System.out.println("selection:\n" + selection);
            Timer.start();
            production_quantity.filter(selection);
            Timer.stop();
            List<ObservationSeries> result = production_quantity.getObservations();
            System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
            RuntimeMemory.printStats();
            production_quantity.reset();
        }
    }

    @Test
    public void testGroupByCountry() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        selection.add(country, country.getObject("UN_CODE", (Object)"032"));
        System.out.println("grouping by country...");
        Timer.start();
        production_quantity.aggregate(selection);
        List<ObservationSeries> result = production_quantity.getObservations();
        Timer.stop();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Country"), (Timer.timeElapsed() < 9000L ? 1 : 0) != 0);
    }

    @Test
    public void testGroupByContinent() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        Concept continent = ReferenceServiceFactory.getService().getConcept("CONTINENT");
        for (ReferenceObject object : continent.getObjects()) {
            selection.add(country, object);
        }
        System.out.println("selection:\n" + selection);
        System.out.println("grouping by continent...");
        Timer.start();
        production_quantity.aggregate(selection);
        Timer.stop();
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("found: " + result.size() + "in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Continent"), (Timer.timeElapsed() < 6500L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTotals() throws Exception {
        System.out.println("calculating totals...");
        Timer.start();
        ObservationSeries result = production_quantity.getTotals(ReferenceObject.ALL);
        Timer.stop();
        System.out.println("calculated totals in " + Timer.timeElapsed() + "msec:\n" + result);
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate totals"), (Timer.timeElapsed() < 3000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersNumber() throws Exception {
        ReferenceObject measure = ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_no_1");
        TopCriteria criteria = new TopCriteria(measure, TopCriteria.CriteriaType.TOP_RECORDS_NUMBER, 1.0);
        System.out.println("calculating top others (number) on measure [" + measure.getAttribute("CODE") + "]...");
        Timer.start();
        production_quantity.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec\n");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(number)"), (Timer.timeElapsed() < 15000L ? 1 : 0) != 0);
        System.out.println("calculating (top/other) totals on same measure...");
        ObservationSeries totals = production_quantity.getTotals(measure);
        System.out.println("totals:\n" + totals);
        double total = 0.0;
        for (Measure m : totals.getMeasures().values()) {
            total += m.getValue();
        }
        Assert.assertTrue((String)"Total is zero", (total != 0.0 ? 1 : 0) != 0);
        System.out.println("calculating (top/other) totals on different measure...");
        measure = ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1");
        totals = production_quantity.getTotals(measure);
        System.out.println("totals:\n" + totals);
        total = 0.0;
        for (Measure m : totals.getMeasures().values()) {
            total += m.getValue();
        }
        Assert.assertTrue((String)"Total should be zero", (total == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersValue() throws Exception {
        ReferenceObject measure = ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_no_1");
        TopCriteria criteria = new TopCriteria(measure, TopCriteria.CriteriaType.TOP_RECORDS_VALUE, 229.0);
        System.out.println("calculating top others (value) on measure [" + measure.getAttribute("CODE") + "]...");
        Timer.start();
        production_quantity.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(value)"), (Timer.timeElapsed() < 15000L ? 1 : 0) != 0);
    }

    @Test
    public void testCalculateTopOthersPercent() throws Exception {
        ReferenceObject measure = ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1");
        TopCriteria criteria = new TopCriteria(measure, TopCriteria.CriteriaType.TOP_RECORDS_PERCENT, 10.0);
        System.out.println("calculating top others (percent) on measure [" + measure.getAttribute("CODE") + "]...");
        Timer.start();
        production_quantity.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to calculate top others(percent)"), (Timer.timeElapsed() < 15000L ? 1 : 0) != 0);
    }

    @Test
    public void testGroupProductionSource() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        ReferenceObject afghanistan = country.getObject("UN_CODE", (Object)"004");
        selection.add(country, afghanistan);
        production_quantity.filter(selection);
        selection = Selection.instance();
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("PRODUCTION_SOURCE_PRODUCTION_SOURCE");
        Concept production_source = ReferenceServiceFactory.getService().getConcept("PRODUCTION_SOURCE");
        for (ReferenceObject object : relationship.getParents()) {
            selection.add(production_source, object);
        }
        System.out.println("selection:\n" + selection);
        System.out.println("grouping by production source...");
        Timer.start();
        production_quantity.aggregate(selection);
        Timer.stop();
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("found: " + result.size() + "in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Continent"), (Timer.timeElapsed() < 6500L ? 1 : 0) != 0);
    }

    @Test
    public void testGroupByFisheryCommission() throws Exception {
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        ReferenceObject states = country.getObject("UN_CODE", (Object)"840");
        selection.add(country, states);
        Concept species = ReferenceServiceFactory.getService().getConcept("SPECIES");
        ReferenceObject acipenseridae = species.getObject("ALPHA_3_CODE", (Object)"STU");
        selection.add(species, acipenseridae);
        Concept source = ReferenceServiceFactory.getService().getConcept("PRODUCTION_SOURCE");
        ReferenceObject freshwater = source.getObject("CODE", (Object)"FRESHWATER");
        selection.add(source, freshwater);
        production_quantity.filter(selection);
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("filtered: " + result.size() + "in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        selection = Selection.instance();
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("COMMISSION_COUNTRY");
        for (ReferenceObject object : relationship.getParents()) {
            selection.add(country, object);
        }
        System.out.println("selection:\n" + selection);
        System.out.println("grouping by fishery commission...");
        Timer.start();
        production_quantity.aggregate(selection);
        Timer.stop();
        result = production_quantity.getObservations();
        System.out.println("grouped: " + result.size() + "in " + Timer.timeElapsed() + "msec");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to group by Continent"), (Timer.timeElapsed() < 6500L ? 1 : 0) != 0);
    }

    @Test
    public void testSort() throws Exception {
        System.out.println("sorting...");
        Timer.start();
        production_quantity.sort(ObservationPeriod.valueOf("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = production_quantity.getObservations();
        System.out.println("sorted: " + result.size() + " in " + Timer.timeElapsed() + "msec");
        Assert.assertTrue((String)("Took: " + Timer.timeElapsed() + " to sort"), (Timer.timeElapsed() < 5000L ? 1 : 0) != 0);
    }
}

