/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.validators;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.ValidationSourcedStatus;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;

public class ConceptAttributeExistenceValidator
implements IValidator<String> {
    private Object source;
    private String concept_acronym;

    public ConceptAttributeExistenceValidator() {
    }

    public ConceptAttributeExistenceValidator(String concept) {
        this.concept_acronym = concept;
    }

    public ConceptAttributeExistenceValidator(Object source) {
        this.source = source;
    }

    public ConceptAttributeExistenceValidator(Object source, String concept) {
        this.source = source;
        this.concept_acronym = concept;
    }

    public IStatus validate(String value) {
        if (value instanceof String) {
            String att_acronym = value;
            Concept concept = ReferenceServiceFactory.getService().getConcept(this.concept_acronym);
            String err_msg_1 = "Undefined concept";
            if (concept == null) {
                return this.source == null ? ValidationStatus.error((String)err_msg_1) : ValidationSourcedStatus.error(err_msg_1, this.source);
            }
            Attribute attribute = concept.getAttribute(att_acronym);
            String err_msg = "Undefined attribute";
            return attribute == null ? (this.source == null ? ValidationStatus.error((String)err_msg) : ValidationSourcedStatus.error(err_msg, this.source)) : Status.OK_STATUS;
        }
        throw new RuntimeException("Not supposed to be called for not-String.");
    }
}

