/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.structure;

import com.csvreader.CsvReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.osgi.framework.Bundle;

public class WorkspaceDataImporter {
    public static void persistConceptData(File referencesFile, SubMonitor submonitor) throws Exception {
        String conceptAcronym = referencesFile.getName().substring(0, referencesFile.getName().length() - 4);
        Concept concept = ReferenceServiceFactory.getService().getConcept(conceptAcronym);
        if (concept == null) {
            throw new Exception("Concept does not exist " + conceptAcronym);
        }
        int lines = CoreUtils.countFileLines(referencesFile);
        BufferedReader rfReader = new BufferedReader(new InputStreamReader(CoreUtils.openFileDiscardBOM(new FileInputStream(referencesFile)), StandardCharsets.UTF_8));
        try {
            List<ReferenceObject> data = WorkspaceDataImporter.readCsvData(concept, rfReader, lines, submonitor);
            concept.addAll(data);
        }
        catch (Exception e) {
            throw new Exception("Unable to load references ", e);
        }
    }

    private static List<ReferenceObject> readCsvData(Concept concept, Reader input, int lines, SubMonitor submonitor) throws Exception {
        ArrayList<ReferenceObject> loaded = new ArrayList<ReferenceObject>();
        CsvReader reader = new CsvReader(input, ',');
        if (!reader.readHeaders()) {
            throw new Exception("CSV header could not be read");
        }
        submonitor.beginTask("Persisting references...", lines);
        while (reader.readRecord()) {
            try {
                ReferenceObject object = concept.createObject();
                for (Attribute attribute : concept.getAttributes()) {
                    if (attribute.getAcronym().equals("ID")) continue;
                    Object attribute_value = null;
                    if (attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                        MultilingualString multi_string = new MultilingualString();
                        for (String lang : MultilingualString.LANGUAGES) {
                            String value = null;
                            value = reader.get(String.valueOf(attribute.getAcronym()) + "_" + lang.toUpperCase());
                            multi_string.setValue(lang, value);
                        }
                        attribute_value = multi_string;
                    } else {
                        String value = reader.get(attribute.getAcronym());
                        if (value != null) {
                            Constructor constructor = attribute.getType().getRuntimeType().getConstructor(String.class);
                            attribute_value = constructor.newInstance(value);
                        }
                    }
                    object.setAttribute(attribute, attribute_value);
                }
                loaded.add(object);
                submonitor.worked(1);
            }
            catch (Exception e) {
                if (reader != null) {
                    reader.close();
                }
                throw new Exception("Unable to read CSV row: " + e.getMessage() + " row=" + (reader.getCurrentRecord() + 1L));
            }
        }
        reader.close();
        return loaded;
    }

    public static void importRelationshipsData(File csvFile) throws Exception {
        Relationship relationship = WorkspaceDataImporter.checkRelationship(csvFile);
        try (CsvReader csvReader = null;){
            csvReader = new CsvReader(csvFile.getAbsolutePath());
            csvReader.readHeaders();
            List<String> headerList = Arrays.asList(csvReader.getHeaders());
            if (!headerList.contains("PARENT_ID")) {
                throw new Exception("CSV header missing [PARENT_ID] column " + headerList.toString());
            }
            if (!headerList.contains("CHILD_ID")) {
                throw new Exception("CSV header missing [CHILD_ID] column " + headerList.toString());
            }
            Concept parent = relationship.getParentConcept();
            Concept child = relationship.getChildConcept();
            relationship.removeAll();
            while (csvReader.readRecord()) {
                long parentCode = Long.parseLong(csvReader.get("PARENT_ID"));
                ReferenceObject parentRO = parent.getObject(parent.getAttribute("EBXID"), (Object)parentCode);
                if (parentRO == null) {
                    throw new Exception("Parent Reference object does not exist: " + parentCode);
                }
                long childCode = Long.parseLong(csvReader.get("CHILD_ID"));
                ReferenceObject childRO = child.getObject(child.getAttribute("EBXID"), (Object)childCode);
                if (childRO == null) {
                    throw new Exception("Child Reference object does not exist" + childCode);
                }
                relationship.add(parentRO, childRO);
            }
        }
    }

    private static Relationship checkRelationship(File file) throws Exception {
        String fileName = file.getName().toUpperCase();
        if (!fileName.endsWith(".CSV")) {
            throw new Exception("expected a CSV file: " + file.getAbsolutePath());
        }
        String relationship_acronym = fileName.substring(0, fileName.length() - 4).toUpperCase();
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship(relationship_acronym);
        if (relationship == null) {
            throw new Exception("Relationship: " + relationship_acronym + " does not exist.");
        }
        return relationship;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importDimensionNote(File csvFile, Dataset ds, String notesAcronym) {
        String table = "NOTE_" + notesAcronym;
        Connection dbConn = null;
        Statement ps1 = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedReader input = new BufferedReader(new InputStreamReader(CoreUtils.openFileDiscardBOM(new FileInputStream(csvFile)), StandardCharsets.UTF_8));){
                dbConn = WorkspaceDataImporter.getConn();
                PreparedStatement psDel = dbConn.prepareStatement("DELETE FROM " + table);
                psDel.executeUpdate();
                psDel.close();
                String sqlQuery1 = "INSERT INTO FISHSTAT." + table + " (ID, NAME_EN, NAME_FR, NAME_ES) VALUES (?,?,?,?)";
                ps1 = dbConn.prepareStatement(sqlQuery1);
                CsvReader csvReader = new CsvReader((Reader)input, ',');
                if (!csvReader.readHeaders()) {
                    return;
                }
                do {
                    if (!csvReader.readRecord()) {
                        csvReader.close();
                        ps1.close();
                        dbConn.close();
                        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
                        log.log((IStatus)new Status(1, WorkspaceDataImporter.class.getName(), String.valueOf(table) + " imported OK."));
                        return;
                    }
                    ps1.setString(1, csvReader.get("ID"));
                    ps1.setString(2, csvReader.get("Name_En"));
                    ps1.setString(3, csvReader.get("Name_Fr"));
                    ps1.setString(4, csvReader.get("Name_Es"));
                } while (ps1.executeUpdate() == 1);
                if (ps1 != null) {
                    ps1.close();
                }
                if (dbConn == null) return;
                dbConn.close();
                return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.core.runtime"));
            log.log((IStatus)new Status(4, WorkspaceDataImporter.class.getName(), String.valueOf(table) + " error", (Throwable)e));
            try {
                if (ps1 != null) {
                    ps1.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (dbConn == null) return;
                dbConn.close();
                return;
            }
            catch (SQLException sQLException) {}
        }
    }

    private static Connection getConn() throws Exception {
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        WorkspaceModel workspaceModel = CoreCommons.getWorkspacesManager().getCurrentWorkspace();
        return DriverManager.getConnection(workspaceModel.getDbUrl(), workspaceModel.getDbUsername(), workspaceModel.getDbPassword());
    }
}

