/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.xmlbinds.workspaces;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.fao.fi.fishstat.core.xmlbinds.workspaces.WorkspaceSystemEntities;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class WorkspaceSystemEntitiesImpl
implements WorkspaceSystemEntities {
    private static String[] concepts = new String[]{"PREDEFINED", "CUSTOM_GROUP", "LANGUAGE", "MEASURE", "MONTH", "QUARTER", "FST_FUNCTION", "FST_PARAMETER", "FST_STAT_ATTRIBUTE"};
    private static String[] relationships = new String[]{"CUSTOM_GROUP_LANGUAGE", "CUSTOM_GROUP_MEASURE", "CUSTOM_GROUP_MONTH", "CUSTOM_GROUP_QUARTER", "QUARTER_MONTH", "FST_FUNCTION_PARAMETER"};
    private static List<String> systemConcepts;
    private static List<String> systemRelationships;

    public WorkspaceSystemEntitiesImpl() {
        if (systemConcepts == null) {
            WorkspaceSystemEntitiesImpl.loadSystemConcepts();
        }
        if (systemRelationships == null) {
            WorkspaceSystemEntitiesImpl.loadSystemRelationships();
        }
    }

    @Override
    public boolean isSystemConcept(Concept concept) {
        if (concept.getAcronym() == null) {
            return false;
        }
        return systemConcepts.contains(concept.getAcronym());
    }

    @Override
    public boolean isSystemRelationship(Relationship relationship) {
        return systemRelationships.contains(relationship.getAcronym());
    }

    private static void loadSystemConcepts() {
        systemConcepts = new Vector<String>();
        systemConcepts.addAll(Arrays.asList(concepts));
    }

    private static void loadSystemRelationships() {
        systemRelationships = new Vector<String>();
        systemRelationships.addAll(Arrays.asList(relationships));
    }
}

