/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.dataset;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.dataset.DimensionNoteModel;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;
import org.fao.fi.fishstat.data.timeseries.api.impl.DimensionNoteImpl;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.exceptions.TimeseriesManagementException;

public class DimensionNoteModelImpl
implements DimensionNoteModel,
Cloneable,
PropertyChangeListener {
    private DimensionNote originalInstance = null;
    private Dataset dataset;
    private Dimension dimension;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DimensionNoteModelImpl(Dataset dataset, Dimension dimension) {
        this.dataset = dataset;
        this.dimension = dimension;
    }

    public DimensionNoteModelImpl(DimensionNoteModelImpl copy) {
        this.dataset = copy.getDataset();
        this.dimension = copy.getDimension();
    }

    @Override
    public DimensionNote getInstance() {
        return this.originalInstance;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public boolean isNative() {
        return this.originalInstance != null;
    }

    @Override
    public boolean isSynchronised() {
        return this.originalInstance != null;
    }

    @Override
    public void persistModel(IProgressMonitor monitor) throws TimeseriesManagementException {
        if (this.isNative()) {
            throw new TimeseriesManagementException("Dataset modification is not possible; delete then add");
        }
        this.originalInstance = this.persistDimensionNote(monitor);
    }

    private DimensionNote persistDimensionNote(IProgressMonitor monitor) throws TimeseriesManagementException {
        monitor.beginTask("Saving DimensionNote ...", 10);
        monitor.worked(1);
        DimensionNoteImpl descriptor = new DimensionNoteImpl(this.getDataset(), this.getDimension());
        DimensionNote dimensionNote = TimeseriesManagementServiceFactory.getService().createDimensionNote((DimensionNote)descriptor);
        monitor.internalWorked(1.0);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(DimensionNote.class);
        return dimensionNote;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.propertyChangeSupport.firePropertyChange(evt);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public String getAcronym() {
        return "NOTE_" + this.dataset.getAcronym() + "_" + this.dimension.getAcronym();
    }

    @Override
    public void setInstance(DimensionNoteImpl note) {
        this.originalInstance = note;
    }
}

