/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.management.descriptors;

import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.AttributeDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.ConceptDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.RelationshipDescriptor;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.impl.AttributeDescriptorImpl;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.impl.ConceptDescriptorImpl;
import org.fao.fi.fishstat.data.reference.api.management.descriptors.impl.RelationshipDescriptorImpl;

public class DescriptorsFactory {
    private DescriptorsFactory() {
        throw new IllegalStateException("Utility class");
    }

    public static AttributeDescriptor createAttributeDescriptor(Identifier conceptID, String acronym, MultilingualString name, MultilingualString description, AttributeType type, short size, short scale, boolean isCode, boolean isName) {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl();
        descriptor.setConceptId(conceptID);
        descriptor.setAcronym(acronym);
        descriptor.setName(name);
        descriptor.setDescription(description);
        descriptor.setType(type);
        descriptor.setSize(size);
        descriptor.setScale(scale);
        descriptor.setCodeAttribute(isCode);
        descriptor.setNameAttribute(isName);
        return descriptor;
    }

    public static AttributeDescriptor createAttributeDescriptor(Attribute attribute) {
        AttributeDescriptorImpl descriptor = new AttributeDescriptorImpl();
        descriptor.setConceptId(attribute.getConcept().getId());
        descriptor.setAcronym(attribute.getAcronym());
        descriptor.setName(attribute.getName());
        descriptor.setDescription(attribute.getDescription());
        descriptor.setType(attribute.getType());
        descriptor.setSize(attribute.getSize());
        descriptor.setScale(attribute.getScale());
        descriptor.setCodeAttribute(attribute.isCodeAttribute());
        descriptor.setNameAttribute(attribute.isNameAttribute());
        return descriptor;
    }

    public static ConceptDescriptor createConceptDescriptor(String acronym, MultilingualString name, MultilingualString description, Version version, Integer sortorder) {
        ConceptDescriptorImpl descriptor = new ConceptDescriptorImpl();
        descriptor.setAcronym(acronym);
        descriptor.setName(name);
        descriptor.setDescription(description);
        descriptor.setVersion(version);
        descriptor.setSortorder(sortorder);
        return descriptor;
    }

    public static ConceptDescriptor createConceptDescriptor(Concept concept) {
        ConceptDescriptorImpl descriptor = new ConceptDescriptorImpl();
        descriptor.setAcronym(concept.getAcronym());
        descriptor.setName(concept.getName());
        descriptor.setDescription(concept.getDescription());
        descriptor.setVersion(concept.getVersion());
        descriptor.setSortorder(concept.getSortorder());
        return descriptor;
    }

    public static RelationshipDescriptor createRelationshipDescriptor(String acronym, MultilingualString name, MultilingualString description, Identifier parent, Identifier child, Version version, Integer sortorder) {
        RelationshipDescriptorImpl descriptor = new RelationshipDescriptorImpl();
        descriptor.setAcronym(acronym);
        descriptor.setName(name);
        descriptor.setDescription(description);
        descriptor.setParentConceptId(parent);
        descriptor.setChildConceptId(child);
        descriptor.setVersion(version);
        descriptor.setSortorder(sortorder);
        return descriptor;
    }

    public static RelationshipDescriptor createRelationshipDescriptor(Relationship relationship) {
        RelationshipDescriptorImpl descriptor = new RelationshipDescriptorImpl();
        descriptor.setAcronym(relationship.getAcronym());
        descriptor.setName(relationship.getName());
        descriptor.setDescription(relationship.getDescription());
        descriptor.setParentConceptId(relationship.getParentConcept().getId());
        descriptor.setChildConceptId(relationship.getChildConcept().getId());
        descriptor.setVersion(relationship.getVersion());
        descriptor.setSortorder(relationship.getSortorder());
        return descriptor;
    }
}

