/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.ConceptImpl;

public class GenericReferenceObject
implements ReferenceObject {
    private Concept concept;
    private Map<Attribute, Object> attributes;

    public GenericReferenceObject(Concept concept) {
        this.concept = concept;
        this.attributes = Collections.synchronizedMap(new HashMap());
        for (Attribute attribute : concept.getAttributes()) {
            this.attributes.put(attribute, null);
        }
        this.attributes.remove(concept.getAttribute("ID"));
    }

    public GenericReferenceObject(ConceptImpl concept, Map<Attribute, Object> provided) {
        this.concept = concept;
        this.attributes = Collections.synchronizedMap(new HashMap());
        for (Attribute attribute : concept.getAttributes()) {
            this.attributes.put(attribute, null);
        }
        this.attributes.remove(concept.getAttribute("ID"));
        this.setAttributes(provided);
    }

    @Override
    public Object getAttribute(String acronym) throws ReferenceServiceException {
        return this.attributes.get(this.concept.getAttribute(acronym));
    }

    @Override
    public Object getAttribute(Attribute meta) throws ReferenceServiceException {
        return this.attributes.get(meta);
    }

    @Override
    public Map<Attribute, Object> getAttributes() throws ReferenceServiceException {
        return new HashMap<Attribute, Object>(this.attributes);
    }

    @Override
    public Concept getConcept() {
        return this.concept;
    }

    @Override
    public Identifier getId() {
        return Identifier.NULL_ID;
    }

    @Override
    public void setAttribute(Attribute attribute, Object value) throws ReferenceServiceException {
        if (attribute == null) {
            throw new IllegalArgumentException("Expecting not null attribute value");
        }
        if (!this.attributes.keySet().contains(attribute)) {
            throw new IllegalArgumentException("Meta attribute not defined: " + attribute);
        }
        if ("ID".equalsIgnoreCase(attribute.getAcronym())) {
            throw new IllegalArgumentException("Can not set the ID attribute");
        }
        this.attributes.put(attribute, value);
    }

    @Override
    public void setAttribute(String acronym, Object value) throws ReferenceServiceException {
        if (acronym == null) {
            throw new IllegalArgumentException("Expecting not null attribute acronym");
        }
        Attribute meta = this.getConcept().getAttribute(acronym);
        this.setAttribute(meta, value);
    }

    @Override
    public void setAttributes(Map<Attribute, Object> provided) throws ReferenceServiceException {
        if (provided == null) {
            throw new IllegalArgumentException("Expecting not null attribute values");
        }
        for (Map.Entry<Attribute, Object> entry : provided.entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode = 31 * hashcode + (this.getConcept() == null ? 0 : this.getConcept().hashCode());
        hashcode = 31 * hashcode + (this.getId() == null ? 0 : this.getId().hashCode());
        return hashcode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceObject)) {
            return false;
        }
        ReferenceObject other = (ReferenceObject)obj;
        if (this.getConcept() == null ? other.getConcept() != null : !this.getConcept().equals(other.getConcept())) {
            return false;
        }
        return this.getId().equals(other.getId());
    }
}

