/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.autoupdate;

import java.awt.Desktop;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.fao.fi.fishstat.autoupdate.ParseVersion;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdate;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.autoupdate.AutoupdateMac;
import org.fao.fi.fishstat.gui.autoupdate.AutoupdateUtil;
import org.fao.fi.fishstat.gui.autoupdate.AutoupdateWindows;
import org.fao.fi.fishstat.gui.autoupdate.DownloadFile;

public class AutoUpdateMain {
    private boolean hasValidAutoUpdate = false;
    private AutoUpdate autoupdate = null;
    String currentVersionURL = null;

    public AutoUpdateMain() {
        try {
            this.currentVersionURL = Activator.getDefault().getPreferenceStore().getString("xml.version.url");
            String versionXML = AutoupdateUtil.getCurrentVersionXML(this.currentVersionURL);
            if (versionXML == null || versionXML.isEmpty()) {
                Activator.getDefault().getLog().log((IStatus)new Status(2, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.downloadfailed"), this.currentVersionURL)));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"FishStatJ is working off-line", (String)(this.currentVersionURL == null ? "Cannot connect to www.fao.org" : String.valueOf(this.currentVersionURL) + "\n" + "a check for application updates and download of data is not possible.\n\n" + "Only workspaces installed previously are available.\n\n" + "To fix this, please connect to the internet or update firewall settings."));
                return;
            }
            ParseVersion xmlVersion = new ParseVersion(versionXML);
            this.autoupdate = xmlVersion.getAutoupdate();
            if (this.autoupdate.getAutoUpdateWks().isEmpty()) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.noworkspaces")));
                return;
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.status"), AutoupdateUtil.getCurrentVersion().toString(), this.autoupdate.getVersion(), this.autoupdate.getDate(), this.currentVersionURL)));
            this.hasValidAutoUpdate = true;
        }
        catch (Exception exp) {
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.general"), this.currentVersionURL), (Throwable)exp));
        }
    }

    public List<AutoUpdateWks> getAutoupdateWorkspaces() {
        if (!this.hasValidAutoUpdate) {
            return new ArrayList<AutoUpdateWks>();
        }
        return this.autoupdate.getAutoUpdateWks();
    }

    private boolean isNewVersionAvailable() {
        if (!this.hasValidAutoUpdate) {
            return false;
        }
        VersionId updateVersion = new VersionId(this.autoupdate.getVersion());
        return updateVersion.compareTo(AutoupdateUtil.getCurrentVersion()) > 0;
    }

    public String openManual(boolean isManual) {
        File workspaceRoot = CoreCommons.getWorkspacesManager().getRoot();
        File manualFolder = new File(String.valueOf(workspaceRoot.getAbsolutePath()) + File.separator + "manual");
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("mac") != -1) {
            manualFolder = new File(".");
        }
        if (!manualFolder.exists() && !manualFolder.mkdir()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.manualfolder")));
            return Activator.getPluginBundle().getString("autoupdate.error.manualfolder");
        }
        String manualPath = null;
        String manualURL = null;
        if (this.hasValidAutoUpdate) {
            DownloadFile dl;
            manualURL = isManual ? this.autoupdate.getManual() : this.autoupdate.getQuickref();
            manualPath = String.valueOf(manualFolder.getAbsolutePath()) + File.separator + manualURL.substring(manualURL.lastIndexOf(47) + 1, manualURL.length());
            if (!(new File(manualPath).exists() && new File(manualPath).length() >= 5000L || (dl = new DownloadFile(manualURL)).doDownload(manualFolder.getAbsolutePath()))) {
                return Activator.getPluginBundle().getString("autoupdate.error.download");
            }
        } else {
            File[] manuals = manualFolder.listFiles();
            if (manuals.length == 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.nocachedpdf")));
                return Activator.getPluginBundle().getString("autoupdate.error.nocachedpdf");
            }
            manualPath = manuals[manuals.length - 1].getAbsolutePath();
            Activator.getDefault().getLog().log((IStatus)new Status(1, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.path"), manualPath)));
        }
        if (manualPath == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), Activator.getPluginBundle().getString("autoupdate.error.invalidpath")));
            return Activator.getPluginBundle().getString("autoupdate.error.invalidpath");
        }
        if (!this.openPDF(manualPath)) {
            return Activator.getPluginBundle().getString("autoupdate.error.openpdf");
        }
        return null;
    }

    boolean openPDF(String pdfPath) {
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe \"" + new File(pdfPath).toURI().toURL().toString() + "\"");
            } else {
                Desktop.getDesktop().open(new File(pdfPath));
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, this.getClass().getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.error.openpdf"), pdfPath), (Throwable)e));
            return false;
        }
        return true;
    }

    public void doAutoupdate() {
        if (this.isNewVersionAvailable()) {
            AutoupdateUtil.stopAutomenu();
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") != -1) {
                AutoupdateWindows.update(this.autoupdate, this.hasValidAutoUpdate);
            } else {
                AutoupdateMac.downloadProgram(this.autoupdate);
            }
        }
    }

    public boolean doShowUserSurvey() {
        if (!this.hasValidAutoUpdate) {
            return false;
        }
        if (this.isNewVersionAvailable()) {
            return false;
        }
        return this.autoupdate.getUrlsurvey() != null && !this.autoupdate.getUrlsurvey().isEmpty() && !this.autoupdate.getUrlsurvey().equals("none");
    }

    public String getSurveyUrl() {
        return this.autoupdate.getUrlsurvey();
    }
}

