/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api.workspace;

import java.io.File;
import java.net.URL;
import org.fao.fi.fishstat.data.common.api.workspace.Workspace;
import org.fao.fi.fishstat.data.common.api.workspace.impl.WorkspaceImpl;
import org.fao.fi.fishstat.data.common.utils.ZipUtility;

public class DerbyWorkspaceHelper {
    public static final String DB_PATH = "db";
    public static final String JAR_PATH = "fishstatj-jdbc-dao.jar";
    private static final String DERBY_JBDC_URL_PREFIX = "jdbc:derby:";

    public static void deploy(URL zip, String target, boolean cleanup) throws Exception {
        File destination = new File(target);
        if (!destination.exists()) {
            ZipUtility.unzip(zip, destination);
        } else if (cleanup) {
            DerbyWorkspaceHelper.deleteDirectory(destination);
            ZipUtility.unzip(zip, destination);
        }
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    DerbyWorkspaceHelper.deleteDirectory(files[i]);
                } else if (!files[i].delete()) break;
                ++i;
            }
        }
        return path.delete();
    }

    public static Workspace unpackDerbyWorkspace(URL dws, String destination, boolean cleanup) throws Exception {
        return DerbyWorkspaceHelper.unpackDerbyWorkspace(dws, destination, cleanup, null, null);
    }

    public static Workspace unpackDerbyWorkspace(URL dws, String destination, boolean cleanup, String dbZipPath, String jarZipPath) throws Exception {
        DerbyWorkspaceHelper.deploy(dws, destination, cleanup);
        String jdbc_url = DERBY_JBDC_URL_PREFIX + destination + File.separator + (dbZipPath == null ? DB_PATH : dbZipPath);
        URL jar_url = new File(String.valueOf(destination) + File.separator + (jarZipPath == null ? JAR_PATH : jarZipPath)).toURI().toURL();
        return new WorkspaceImpl(jdbc_url, jar_url);
    }
}

