/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.firestorm;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class FileListing {
    public static List<File> getFileListing(File aStartingDir) throws FileNotFoundException {
        FileListing.validateDirectory(aStartingDir);
        List<File> result = FileListing.getFileListingNoSort(aStartingDir);
        Collections.sort(result);
        return result;
    }

    private static List<File> getFileListingNoSort(File aStartingDir) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            if (!file.isFile()) {
                List<File> deeperList = FileListing.getFileListingNoSort(file);
                result.addAll(deeperList);
                continue;
            }
            result.add(file);
        }
        return result;
    }

    private static void validateDirectory(File aDirectory) throws FileNotFoundException {
        if (aDirectory == null) {
            throw new IllegalArgumentException("Directory should not be null.");
        }
        if (!aDirectory.exists()) {
            throw new FileNotFoundException("Directory does not exist: " + aDirectory);
        }
        if (!aDirectory.isDirectory()) {
            throw new IllegalArgumentException("Is not a directory: " + aDirectory);
        }
        if (!aDirectory.canRead()) {
            throw new IllegalArgumentException("Directory cannot be read: " + aDirectory);
        }
    }
}

