/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.FIESMeasureSymbol;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinitionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Descriptive;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.FunctionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeseriesCalculatedObservationsTestCase {
    private static Dataset dataset;
    private static Timeseries timeseries;

    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        dataset = TimeseriesServiceFactory.getService().getDataset("AQUACULTURE");
        timeseries = dataset.getTimeseries("QUANTITY");
    }

    @Test
    public void testDefinitions() throws Exception {
        Set<Function> functions = FunctionFactory.getAvailableFunctions();
        for (Function function : functions) {
            System.out.println(function.getName());
            Collection<Parameter> parameters = function.getParameters();
            for (Parameter parameter : parameters) {
                System.out.println(parameter);
                String[] values = parameter.getEnumeratedValues();
                if (values == null) continue;
                for (String value : Arrays.asList(values)) {
                    System.out.println(value);
                }
            }
        }
    }

    @Test
    public void testAddCalculatedArithmeticMean() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Arithmetic mean");
        definition.setFunction(FunctionFactory.getFunction("ARITHMETIC_MEAN"));
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
    }

    @Test
    public void testAddCalculatedVariance() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Variance");
        Function variance = FunctionFactory.getFunction("VARIANCE");
        definition.setFunction(variance);
        Parameter bias_corrected = variance.getParameter("BIAS_CORRECTED");
        HashMap<Parameter, String> parameters = new HashMap<Parameter, String>();
        parameters.put(bias_corrected, Boolean.TRUE.toString());
        definition.setParameters(parameters);
        definition.setPeriods(ObservationPeriod.parseRange("Y2000,Y2001,Y2002..Y2006,Y2007", timeseries.getTimeResolution()));
        HashSet<MeasureStatus> skip_status = new HashSet<MeasureStatus>();
        skip_status.add(FIESMeasureSymbol.ZERO);
        definition.setSkipStatus(skip_status);
        timeseries.addCalculatedMeasureDefinition(definition);
    }

    @Test
    public void testAddCalculatedRootMeanSquare() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Root Mean Square");
        definition.setFunction(FunctionFactory.getFunction("ROOT_MEAN_SQUARE"));
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
    }

    @Test
    public void testAddCorrelationCoefficient() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Correlation coefficient");
        definition.setFunction(FunctionFactory.getFunction("REG_CORRELATION_COEFFICIENT"));
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
    }

    @Test
    public void testAddCalculatedCustom() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Custom sum");
        Descriptive custom = new Descriptive(){

            public Set<Parameter> getParameters() {
                return null;
            }

            @Override
            public Parameter getParameter(String acronym) {
                return null;
            }

            @Override
            public MultilingualString getName() {
                return null;
            }

            @Override
            public MultilingualString getDescription() {
                return null;
            }

            @Override
            public String getAcronym() {
                return "CUSTOM_SUM";
            }

            @Override
            public double evaluate(List<Double> values, Map<Parameter, String> parameters) {
                double sum = 0.0;
                for (double value : values) {
                    sum += value;
                }
                return sum;
            }

            public int hashCode() {
                int result = 1;
                result = 31 * result + (this.getAcronym() == null ? 0 : this.getAcronym().hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof Function)) {
                    return false;
                }
                Function other = (Function)obj;
                return !(this.getAcronym() == null ? other.getAcronym() != null : !this.getAcronym().equals(other.getAcronym()));
            }

            public String toString() {
                return this.getAcronym();
            }
        };
        definition.setFunction(custom);
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
    }

    @Test
    public void testAddPredictedValue() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Y2010");
        Function predict = FunctionFactory.getFunction("REG_PREDICT");
        definition.setFunction(predict);
        Parameter year = predict.getParameter("PREDICTED_PERIOD");
        HashMap<Parameter, String> parameters = new HashMap<Parameter, String>();
        parameters.put(year, "Y2010");
        definition.setParameters(parameters);
        timeseries.addCalculatedMeasureDefinition(definition);
    }

    @Test
    public void testFunctionParameters() throws Exception {
        Function predict = FunctionFactory.getFunction("VARIANCE");
        for (Parameter param : predict.getParameters()) {
            System.out.println(param);
            String[] stringArray = param.getEnumeratedValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                System.out.println(value);
                ++n2;
            }
        }
    }

    @Test
    public void testGetCalculatedMeasures() throws Exception {
        System.out.println("DEFINITIONS:");
        for (CalculatedMeasureDefinition definition : timeseries.getCalculatedMeasureDefinitions()) {
            System.out.println(definition);
        }
        Selection selection = Selection.instance();
        Concept country = ReferenceServiceFactory.getService().getConcept("COUNTRY");
        ReferenceObject all = ReferenceObject.ALL;
        selection.add(country, all);
        timeseries.aggregate(selection);
        System.out.println("AGGREGATED CALCULATED MEASURES:");
        for (ObservationSeries series : timeseries.getObservations()) {
            System.out.println(series.getCalculatedMeasure(0));
            System.out.println(series.getCalculatedMeasures().values());
        }
        timeseries.reset();
        System.out.println("RAW CALCULATED MEASURE:");
        for (ObservationSeries series : timeseries.getObservations()) {
            System.out.println(series.getCalculatedMeasures().values());
        }
    }
}

