/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.exchange.timeseries;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructure;
import org.fao.fi.fishstat.core.model.exchange.timeseries.TimeSeriesStructureElement;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class TimeSeriesStructureImpl
implements TimeSeriesStructure {
    private Dataset dataset;
    private Timeseries timeseries;
    private int protocol;
    private TimeResolution resolution;
    private String datasource;
    private int structure;
    private ObservationPeriod firstPeriod;
    private ObservationPeriod lastPeriod;
    private List<TimeSeriesStructureElement> elements;
    private HashMap<String, TimeSeriesStructureElement> dimensionsMap;
    private LinkedHashMap<ObservationPeriod, Integer> periodColumns;

    public TimeSeriesStructureImpl(Timeseries timeseries, Dataset dataset) {
        this.timeseries = timeseries;
        this.dataset = dataset;
        this.elements = new LinkedList<TimeSeriesStructureElement>();
        this.dimensionsMap = new HashMap();
        this.periodColumns = new LinkedHashMap();
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public Timeseries getTimeseries() {
        return this.timeseries;
    }

    @Override
    public int getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    @Override
    public TimeResolution getTimeResolution() {
        return this.resolution;
    }

    @Override
    public void setTimeResolution(TimeResolution resolution) {
        this.resolution = resolution;
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    @Override
    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    @Override
    public int getStructure() {
        return this.structure;
    }

    @Override
    public void setStructure(int structure) {
        this.structure = structure;
    }

    @Override
    public ObservationPeriod getFirstPeriod() {
        return this.firstPeriod;
    }

    @Override
    public void setFirstPeriod(ObservationPeriod firstPeriod) {
        this.firstPeriod = firstPeriod;
    }

    @Override
    public ObservationPeriod getLastPeriod() {
        return this.lastPeriod;
    }

    @Override
    public void setLastPeriod(ObservationPeriod lastPeriod) {
        this.lastPeriod = lastPeriod;
    }

    @Override
    public List<TimeSeriesStructureElement> getElements() {
        return this.elements;
    }

    @Override
    public void addElement(TimeSeriesStructureElement element) {
        element.setIdx(this.elements.size());
        this.elements.add(element);
        if (element.getType() == 10) {
            this.dimensionsMap.put(this.createKey(element.getConcept(), element.getAttribute(), element.getLn()), element);
        }
    }

    @Override
    public TimeSeriesStructureElement getElement(int idx) {
        return this.elements.get(idx);
    }

    @Override
    public TimeSeriesStructureElement getDimensionElement(Concept concept, Attribute attribute) {
        return this.dimensionsMap.get(this.createKey(concept, attribute, null));
    }

    @Override
    public boolean hasDimensionElement(Concept concept, Attribute attribute) {
        return this.dimensionsMap.containsKey(this.createKey(concept, attribute, null));
    }

    @Override
    public TimeSeriesStructureElement getDimensionElement(Concept concept, Attribute attribute, String lang) {
        return this.dimensionsMap.get(this.createKey(concept, attribute, lang));
    }

    @Override
    public boolean hasDimensionElement(Concept concept, Attribute attribute, String lang) {
        return this.dimensionsMap.containsKey(this.createKey(concept, attribute, lang));
    }

    @Override
    public void addDenormalizedPeriodColumn(ObservationPeriod period, int colidx) {
        this.periodColumns.put(period, colidx);
    }

    @Override
    public int getDenormalizedPeriodColumn(ObservationPeriod period) {
        return this.periodColumns.containsKey(period) ? this.periodColumns.get(period) : 0;
    }

    @Override
    public Set<ObservationPeriod> getObservationPeriods() {
        if (this.structure == 1) {
            return null;
        }
        return this.periodColumns.keySet();
    }

    private String createKey(Concept concept, Attribute attribute, String lang) {
        StringBuffer res = new StringBuffer();
        res.append(concept != null ? concept.getAcronym() : "");
        res.append("-");
        res.append(attribute != null ? attribute.getAcronym() : "");
        res.append("-");
        res.append(lang != null ? lang : "");
        return res.toString();
    }
}

