/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.workspaces.data;

import com.csvreader.CsvReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.SubMonitor;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.workspaces.data.HeaderEntity;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.MeasureFactory;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.SDMXMeasureStatus;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;

public class TimeseriesCsvImporter {
    public static final String PERIOD = "PERIOD";
    public static final String VALUE = "VALUE";
    public static final String STATUS = "STATUS";
    public static final String MEASURE = "MEASURE";
    public static final String MEASURE_UNIT_CODE = "CODE";

    public static void persistTimeseriesData(File normalizedCSV, SubMonitor submonitor) throws Exception {
        ArrayList<HeaderEntity> dimensionHeaders = new ArrayList<HeaderEntity>();
        Timeseries timeseries = TimeseriesCsvImporter.getDatasetTimeseriesName(normalizedCSV, dimensionHeaders);
        SubMonitor cleanMonitor = submonitor.split(20);
        cleanMonitor.subTask("Truncating " + timeseries.getAcronym());
        cleanMonitor.setWorkRemaining(1);
        timeseries.clean();
        cleanMonitor.worked(1);
        int lines = CoreUtils.countFileLines(normalizedCSV);
        TimeseriesCsvImporter.importTimeseries(timeseries, new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(normalizedCSV.getAbsolutePath())), StandardCharsets.UTF_8), submonitor, dimensionHeaders, lines);
    }

    private static Timeseries getDatasetTimeseriesName(File csvFile, List<HeaderEntity> dimensionHeaders) throws Exception {
        String fileName = csvFile.getName().toUpperCase();
        if (!fileName.endsWith(".CSV")) {
            throw new Exception("CSV file is expected. " + csvFile.getAbsolutePath());
        }
        fileName = fileName.substring(0, fileName.length() - 4);
        String dataset_acronym = null;
        String timeseries_acronym = null;
        if (fileName.contains(".")) {
            dataset_acronym = fileName.substring(0, fileName.indexOf(46));
            timeseries_acronym = fileName.substring(fileName.indexOf(46) + 1);
        } else if (fileName.contains("_")) {
            dataset_acronym = fileName.substring(0, fileName.indexOf(95));
            timeseries_acronym = fileName.substring(fileName.indexOf(95) + 1);
        }
        if (dataset_acronym == null || timeseries_acronym == null) {
            throw new Exception("Import file must be <DATASET>_<TIMESERIES>.csv or <DATASET>.<TIMESERIES>.csv: " + csvFile.getAbsolutePath());
        }
        Dataset dataset = null;
        Timeseries timeseries = null;
        try {
            dataset = DatasetFactory.instance().getDataset(dataset_acronym);
        }
        catch (Exception e) {
            throw new Exception("Incorrect dataset name: " + dataset_acronym, e);
        }
        if (dataset == null) {
            throw new Exception("Incorrect dataset name: " + dataset_acronym);
        }
        try {
            timeseries = dataset.getTimeseries(timeseries_acronym);
        }
        catch (Exception e) {
            throw new Exception("Incorrect timeseries name: " + timeseries_acronym, e);
        }
        if (timeseries == null) {
            throw new Exception("Incorrect timeseries name: " + timeseries_acronym);
        }
        TimeseriesCsvImporter.validateHeaders(csvFile, dataset, dimensionHeaders);
        return timeseries;
    }

    private static void validateHeaders(File file, Dataset dataset, List<HeaderEntity> dimensionHeaders) throws Exception {
        CsvReader csvReader = new CsvReader(file.getAbsolutePath(), ',', StandardCharsets.UTF_8);
        csvReader.readHeaders();
        String[] headers = csvReader.getHeaders();
        csvReader.close();
        List<String> headerList = Arrays.asList(headers);
        if (!headerList.contains(MEASURE)) {
            throw new Exception("CSV header missing MEASURE column " + headerList.toString());
        }
        if (!headerList.contains(PERIOD)) {
            throw new Exception("CSV header missing PERIOD column " + headerList.toString());
        }
        if (!headerList.contains(VALUE)) {
            throw new Exception("CSV header missing VALUE column " + headerList.toString());
        }
        if (!headerList.contains(STATUS)) {
            throw new Exception("CSV header missing STATUS column " + headerList.toString());
        }
        int i = 0;
        while (i < headers.length) {
            String oneHeader = headers[i];
            if (!(oneHeader.equals(PERIOD) || oneHeader.equals(VALUE) || oneHeader.equals(STATUS) || oneHeader.equals(MEASURE))) {
                if (oneHeader.indexOf(46) == -1) {
                    throw new Exception("CSV header format; missing '.' <CONCEPT>.<ATTRIBUTE> unrecognized:" + oneHeader);
                }
                String headerConcept = oneHeader.substring(0, oneHeader.indexOf(46));
                String headerAttribute = oneHeader.substring(oneHeader.indexOf(46) + 1);
                if (!TimeseriesCsvImporter.isDatasetDimension(dataset, headerConcept)) {
                    throw new Exception("CSV header " + oneHeader + ": " + headerConcept + " is not a Dimension");
                }
                if (!TimeseriesCsvImporter.isDatasetDimensionAttribute(dataset, oneHeader, headerConcept, headerAttribute, dimensionHeaders)) {
                    throw new Exception("CSV header " + oneHeader + ": " + headerConcept + " is not a Dimension");
                }
            }
            if (oneHeader.equals(MEASURE)) {
                HeaderEntity entity = new HeaderEntity();
                entity.setHeader(oneHeader);
                entity.setConcept(dataset.getObservedMeasureDimension().getConcept());
                entity.setMeasure(true);
                dimensionHeaders.add(entity);
            }
            ++i;
        }
    }

    private static boolean isDatasetDimensionAttribute(Dataset dataset, String oneHeader, String conceptName, String attributeName, List<HeaderEntity> dimensionHeaders) {
        for (Dimension dimension : dataset.getDimensions()) {
            if (!dimension.getAcronym().equals(conceptName)) continue;
            Concept concept = dimension.getConcept();
            for (Attribute attribute : concept.getAttributes()) {
                if (!attribute.getAcronym().equals(attributeName)) continue;
                HeaderEntity entity = new HeaderEntity();
                entity.setHeader(oneHeader);
                entity.setConcept(concept);
                entity.setAttribute(attribute);
                dimensionHeaders.add(entity);
                return true;
            }
        }
        return false;
    }

    private static boolean isDatasetDimension(Dataset dataset, String concept) {
        for (Dimension dimension : dataset.getDimensions()) {
            if (!dimension.getAcronym().equals(concept)) continue;
            return true;
        }
        return false;
    }

    private static void importTimeseries(Timeseries timeseries, Reader input, SubMonitor submonitor, List<HeaderEntity> dimensionHeaders, int lines) throws Exception {
        SubMonitor importMonitor = submonitor.split(60);
        importMonitor.subTask("reading data ... ");
        importMonitor.setWorkRemaining(lines);
        ArrayList series_list = new ArrayList();
        CsvReader reader = new CsvReader(input, ',');
        if (!reader.readHeaders()) {
            throw new Exception("CSV header could not be read");
        }
        HashMap<MultiReferenceObject, ObservationSeries> series_map = new HashMap<MultiReferenceObject, ObservationSeries>();
        while (reader.readRecord()) {
            List<ReferenceObject> keys = TimeseriesCsvImporter.readDimensionData(dimensionHeaders, reader);
            MultiReferenceObject multi_key = new MultiReferenceObject(keys);
            ObservationSeries series = (ObservationSeries)series_map.get(multi_key);
            if (series == null) {
                series = timeseries.create();
                series.setKeys(multi_key);
                LinkedHashMap<ObservationPeriod, Measure> measures = new LinkedHashMap<ObservationPeriod, Measure>();
                for (ObservationPeriod period : timeseries.getObservationPeriods()) {
                    measures.put(period, MeasureFactory.create());
                }
                series.setMeasures(measures);
                series_map.put(multi_key, series);
            }
            TimeseriesCsvImporter.readObservationData(timeseries, reader, series);
            importMonitor.worked(1);
        }
        series_list.addAll(series_map.values());
        reader.close();
        SubMonitor addMonitor = submonitor.split(20);
        addMonitor.subTask("Persisting data ... " + timeseries.getAcronym());
        addMonitor.setWorkRemaining(1);
        timeseries.add(series_list);
        addMonitor.worked(1);
    }

    private static void readObservationData(Timeseries timeseries, CsvReader reader, ObservationSeries series) throws Exception {
        String period = reader.get(PERIOD);
        if (period == null || period.length() == 0) {
            throw new Exception("Null or empty value read for period " + reader.getCurrentRecord() + 1);
        }
        ObservationPeriod observation_period = new ObservationPeriod(period);
        if (!timeseries.getObservationPeriods().contains(observation_period)) {
            throw new Exception("Period out of bound: " + period + ", row=" + (reader.getCurrentRecord() + 1L));
        }
        Measure observation = series.getMeasure(observation_period);
        String status = reader.get(STATUS);
        if (!SDMXMeasureStatus.isValidStatus((String)status)) {
            throw new Exception("Status flag is not valid: " + period + "=" + status + ", row=" + (reader.getCurrentRecord() + 1L));
        }
        observation.setStatus(new MeasureStatus(status));
        String value = reader.get(VALUE);
        if (value == null || value.length() == 0) {
            throw new Exception("Null or empty value read for period: " + period + ", row=" + (reader.getCurrentRecord() + 1L));
        }
        Double d_value = null;
        try {
            d_value = Double.valueOf(value);
        }
        catch (Exception e) {
            throw new Exception("Unable to parse the observation: " + period + "=" + value + ", row=" + (reader.getCurrentRecord() + 1L) + e.getMessage());
        }
        observation.setValue(d_value.doubleValue());
    }

    private static List<ReferenceObject> readDimensionData(List<HeaderEntity> dimensionHeaders, CsvReader reader) throws Exception {
        ArrayList<ReferenceObject> keys = new ArrayList<ReferenceObject>();
        for (HeaderEntity headerEntity : dimensionHeaders) {
            ReferenceObject key = null;
            if (!headerEntity.isMeasure()) {
                String valuefromcsv = reader.get(headerEntity.getHeader());
                if (valuefromcsv == null || valuefromcsv.length() == 0) {
                    throw new Exception("Null key value read for: " + headerEntity.getConcept().getAcronym() + ", row=" + (reader.getCurrentRecord() + 1L));
                }
                try {
                    switch (headerEntity.getAttribute().getType().getJdbcType()) {
                        case -5: {
                            key = headerEntity.getConcept().getObject(headerEntity.getAttribute(), (Object)Long.valueOf(valuefromcsv));
                            break;
                        }
                        default: {
                            key = headerEntity.getConcept().getObject(headerEntity.getAttribute(), (Object)valuefromcsv);
                            break;
                        }
                    }
                }
                catch (ReferenceServiceException e) {
                    throw new Exception("Unable to get reference object for dimension: " + headerEntity.getConcept().getAcronym() + ", " + headerEntity.getAttribute().getAcronym() + "=" + valuefromcsv + ", row=" + (reader.getCurrentRecord() + 1L), e);
                }
                if (key == null) {
                    throw new Exception("No reference object found for dimension: " + headerEntity.getConcept().getAcronym() + ", " + headerEntity.getAttribute().getAcronym() + "=" + valuefromcsv + ", row=" + (reader.getCurrentRecord() + 1L));
                }
                keys.add(key);
                continue;
            }
            keys.add(headerEntity.getConcept().getObject(MEASURE_UNIT_CODE, (Object)reader.get(headerEntity.getHeader())));
        }
        return keys;
    }
}

