/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.composites;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;

public class WorkspaceMetadataPanel
extends Composite {
    private WorkspaceModel wksModel = null;
    private String locale;
    private Label lblAcronym;
    private Label lblDescription;
    private Label lblProvider;
    private Label lblName;
    private Label lblVersion;
    private Label lblLocation;

    public WorkspaceMetadataPanel(Composite parent, int style, String locale) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.locale = locale;
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginTop = 7;
        gridLayout.marginLeft = 12;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 5;
        gridLayout.horizontalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        Label lblAcronymLabel = new Label((Composite)this, 0);
        lblAcronymLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAcronymLabel.setAlignment(131072);
        lblAcronymLabel.setText(ComponentsActivator.getPluginBundle().getString("workspaces.metadata.acronym"));
        this.lblAcronym = new Label((Composite)this, 0);
        this.lblAcronym.setForeground(SWTResourceManager.getColor(10));
        GridData gdLblAcronymLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.lblAcronym.setLayoutData((Object)gdLblAcronymLabel);
        Label lblVersionLabel = new Label((Composite)this, 0);
        lblVersionLabel.setAlignment(131072);
        GridData gdLblVersionLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblVersionLabel.setLayoutData((Object)gdLblVersionLabel);
        lblVersionLabel.setText(ComponentsActivator.getPluginBundle().getString("workspaces.metadata.version"));
        this.lblVersion = new Label((Composite)this, 0);
        this.lblVersion.setForeground(SWTResourceManager.getColor(10));
        this.lblVersion.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblNameLabel = new Label((Composite)this, 0);
        lblNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNameLabel.setAlignment(131072);
        lblNameLabel.setText(ComponentsActivator.getPluginBundle().getString("workspaces.metadata.name"));
        this.lblName = new Label((Composite)this, 0);
        this.lblName.setForeground(SWTResourceManager.getColor(10));
        GridData gdLblName = new GridData(4, 0x1000000, false, false, 3, 1);
        this.lblName.setLayoutData((Object)gdLblName);
        Label lblDescriptionLabel = new Label((Composite)this, 0);
        GridData gdLblDescriptionLabel = new GridData(131072, 0x1000000, false, false, 1, 1);
        lblDescriptionLabel.setLayoutData((Object)gdLblDescriptionLabel);
        lblDescriptionLabel.setText(ComponentsActivator.getPluginBundle().getString("workspaces.metadata.description"));
        this.lblDescription = new Label((Composite)this, 64);
        this.lblDescription.setForeground(SWTResourceManager.getColor(10));
        this.lblDescription.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        Label lblProviderLabel = new Label((Composite)this, 0);
        lblProviderLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblProviderLabel.setText(ComponentsActivator.getPluginBundle().getString("workspaces.metadata.provider"));
        this.lblProvider = new Label((Composite)this, 0);
        this.lblProvider.setForeground(SWTResourceManager.getColor(10));
        this.lblProvider.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label lblLocationLabel = new Label((Composite)this, 0);
        lblLocationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLocationLabel.setText(ComponentsActivator.getPluginBundle().getString("workspaces.metadata.location"));
        this.lblLocation = new Label((Composite)this, 0);
        this.lblLocation.setForeground(SWTResourceManager.getColor(10));
        this.lblLocation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
    }

    public WorkspaceModel getMetadata() {
        return this.wksModel;
    }

    public void setMetadata(Object metadata) {
        if (metadata == null) {
            this.lblAcronym.setText("");
            this.lblDescription.setText("");
            this.lblName.setText("");
            this.lblProvider.setText("");
            this.lblVersion.setText("");
            this.lblLocation.setText("");
        } else {
            if (metadata instanceof WorkspaceModel) {
                this.wksModel = (WorkspaceModel)metadata;
                this.setMetadataLocalWS((WorkspaceModel)metadata, this.locale);
            }
            if (metadata instanceof AutoUpdateWks) {
                this.wksModel = null;
                this.setMetadataAutoUpdateWS((AutoUpdateWks)metadata);
            }
        }
        this.pack();
    }

    private void setMetadataAutoUpdateWS(AutoUpdateWks metadata) {
        this.lblAcronym.setText(metadata.getAcronym());
        this.lblName.setText(metadata.getDescription());
        this.lblDescription.setText(ComponentsActivator.getDefault().getLocalString("workspaces.metadata.description.automatic"));
        this.lblVersion.setText(metadata.getVersion());
        String url = metadata.getUrl();
        this.lblProvider.setText(url.substring(0, url.lastIndexOf(47)));
        this.lblLocation.setText(url.substring(url.lastIndexOf(47)));
        Color color = Display.getCurrent().getSystemColor(3);
        this.lblAcronym.setForeground(color);
        this.lblName.setForeground(color);
        this.lblDescription.setForeground(color);
        this.lblVersion.setForeground(color);
        this.lblProvider.setForeground(color);
        this.lblLocation.setForeground(color);
    }

    private void setMetadataLocalWS(WorkspaceModel metadata, String locale) {
        this.lblAcronym.setText(metadata.hasAcronym() ? metadata.getAcronym() : "");
        this.lblDescription.setText(metadata.hasDescription(locale) ? metadata.getDescription(locale) : "");
        this.lblName.setText(metadata.hasName(locale) ? metadata.getName(locale) : "");
        this.lblProvider.setText(metadata.hasProvider(locale) ? metadata.getProvider(locale) : "");
        this.lblVersion.setText(metadata.hasVersion() ? metadata.getVersion().toString() : "");
        this.lblLocation.setText(metadata.getWsBaseDir().getAbsolutePath());
        Color color = SWTResourceManager.getColor(10);
        this.lblAcronym.setForeground(color);
        this.lblName.setForeground(color);
        this.lblDescription.setForeground(color);
        this.lblVersion.setForeground(color);
        this.lblProvider.setForeground(color);
        this.lblLocation.setForeground(color);
    }
}

