/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.components.widgets.trees.ReferenceObjectTree;

public class ReferenceObjectDialog
extends TitleAreaDialog {
    private static final int SIZE_WIDTH = 700;
    private static final int SIZE_HEIGHT = 670;
    private ReferenceObject referenceObject;
    private String refereneceLabel;
    private String lang;
    private String note;
    private Text noteText;
    private GridData gdText;
    private GridData gdRefPanel;

    public ReferenceObjectDialog(Shell parentShell, ReferenceObject referenceObject, String label, String note, String lang) {
        super(parentShell);
        this.referenceObject = referenceObject;
        this.refereneceLabel = label;
        this.lang = lang;
        this.note = note;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.refereneceLabel);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.note != null) {
            this.noteText = new Text(container, 832);
            this.noteText.setText(this.note);
            this.gdText = new GridData();
            this.gdText.widthHint = 675;
            this.gdText.heightHint = 244;
            this.noteText.setLayoutData((Object)this.gdText);
        }
        ReferenceObjectTree referenceObjectPanel = new ReferenceObjectTree(container, 0, this.referenceObject, this.lang);
        this.gdRefPanel = new GridData(4, 4, true, true, 1, 1);
        referenceObjectPanel.setLayoutData(this.gdRefPanel);
        referenceObjectPanel.setLayout((Layout)new GridLayout(1, false));
        container.addListener(11, event -> {
            int width = composite.getSize().x - 25;
            int height = composite.getSize().y - 60;
            if (this.noteText != null) {
                this.gdText.widthHint = width;
                this.gdText.heightHint = height * 400 / 1000;
                this.gdRefPanel.widthHint = width;
                this.gdRefPanel.heightHint = height * 600 / 1000;
            } else {
                this.gdRefPanel.widthHint = width;
                this.gdRefPanel.heightHint = height;
            }
            container.layout();
        });
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(700, 670);
    }

    protected boolean isResizable() {
        return true;
    }
}

