/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.autoupdate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdate;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.autoupdate.AutoupdateUtil;
import org.fao.fi.fishstat.gui.autoupdate.DownloadFile;

public class AutoupdateWindows {
    private AutoupdateWindows() {
    }

    public static void update(AutoUpdate autoupdate, boolean hasValidAutoUpdate) {
        String exeDownloadURL = autoupdate.getDownloadwin();
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Activator.getPluginBundle().getString("label.autoupdate.newversion.title"), null, MessageFormat.format(Activator.getPluginBundle().getString("label.autoupdate.newversion.windows"), autoupdate.getVersion()), 2, new String[]{Activator.getPluginBundle().getString("autoupdate.ask.install"), Activator.getPluginBundle().getString("autoupdate.ask.manual"), Activator.getPluginBundle().getString("autoupdate.ask.cancel")}, 0);
        int result = dialog.open();
        if (result == 2) {
            return;
        }
        if (result == 1) {
            if (!hasValidAutoUpdate) {
                return;
            }
            AutoupdateUtil.openWebSite(autoupdate.getUrl());
            return;
        }
        File downloadFolder = AutoupdateWindows.getDownloadFolder();
        if (!downloadFolder.exists()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AutoupdateWindows.class.getName(), MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.error.folder"), downloadFolder.getAbsolutePath())));
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getPluginBundle().getString("autoupdate.httpget.error"), (String)MessageFormat.format(Activator.getPluginBundle().getString("autoupdate.httpget.error.folder"), downloadFolder.getAbsolutePath()));
            return;
        }
        String exePath = String.valueOf(downloadFolder.getAbsolutePath()) + File.separator + exeDownloadURL.substring(exeDownloadURL.lastIndexOf(47) + 1, exeDownloadURL.length());
        String batchFilePath = String.valueOf(downloadFolder.getAbsolutePath()) + File.separator + "FishStatJ_update.bat";
        if (!AutoupdateWindows.writeBatchFile(batchFilePath, exePath)) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getPluginBundle().getString("autoupdate.httpget.error"), (String)Activator.getPluginBundle().getString("autoupdate.error.download"));
            return;
        }
        DownloadFile dl = new DownloadFile(autoupdate.getDownloadwin());
        if (!dl.doDownload(null)) {
            return;
        }
        if (!new File(exePath).exists()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AutoupdateWindows.class.getName(), Activator.getPluginBundle().getString("autoupdate.error.download")));
            return;
        }
        ProcessBuilder processBuilder = new ProcessBuilder("cmd", "/c", "start", batchFilePath);
        try {
            processBuilder.start();
        }
        catch (IOException iOException) {}
        System.exit(0);
    }

    private static boolean writeBatchFile(String batchFilePath, String exePath) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(batchFilePath), StandardCharsets.UTF_8);){
                writer.write("cd \\\n");
                writer.write("@rem wait for app to shutdown\r\n");
                writer.write("ping localhost -n 3 >NUL\r\n");
                writer.write("@rem delete old version\r\n");
                writer.write("rd C:\\FishStatJ /S /Q\r\n");
                writer.write("@rem extract new version\r\n");
                writer.write(String.valueOf(exePath) + "\r\n");
                writer.write("@exit\r\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, AutoupdateWindows.class.getName(), Activator.getPluginBundle().getString("autoupdate.error.download")));
            return false;
        }
        return true;
    }

    private static File getDownloadFolder() {
        String downloadPath = Activator.getDefault().getPreferenceStore().getString("workspace.download.folder");
        File downloadFolder = null;
        if (downloadPath != null) {
            downloadFolder = new File(downloadPath);
        }
        if (downloadFolder.exists() && downloadFolder.isDirectory()) {
            return downloadFolder;
        }
        downloadFolder = new File(Commons.TMP_DIR);
        return downloadFolder;
    }
}

