/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.dynamics;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.fao.fi.fishstat.core.FocusEntity;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.DimensionNote;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.dialogs.ReferenceObjectDialog;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;

public class ReferenceObjectPanelHandler
extends AbstractHandler
implements IHandler,
IElementUpdater {
    public static final String ID = "org.fao.fi.fishstat.gui.command.dynamic.contextual.referenceobject";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() == null) {
            return null;
        }
        FocusEntity lastEntity = session.getLastFocusEntity();
        Object lastClicked = lastEntity.getEntity();
        if (lastClicked instanceof ReferenceObject) {
            ReferenceObject referenceObject = (ReferenceObject)lastClicked;
            String noteString = null;
            Dataset dataset = session.getDataset();
            DimensionNote dimensionNote = dataset.getNotes(referenceObject.getConcept(), Activator.getLanguage());
            if (dimensionNote != null) {
                noteString = dimensionNote.getNoteString(referenceObject);
            }
            ReferenceObjectDialog dialog = new ReferenceObjectDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), referenceObject, lastEntity.getLabel(), noteString, Activator.getLanguage());
            dialog.open();
        }
        return null;
    }

    public boolean isEnabled() {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session == null || session.getLastFocusEntity() == null) {
            return false;
        }
        return session.getLastFocusEntity().hasEntity();
    }

    public void updateElement(UIElement element, Map parameters) {
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        if (session != null && session.getLastFocusEntity() != null) {
            FocusEntity lf = session.getLastFocusEntity();
            if (lf.getColumnDescriptor() == null) {
                element.setText(Activator.getLocalString("label.notes.on"));
            } else {
                element.setText(String.valueOf(Activator.getLocalString("label.notes.on")) + " " + lf.getLabel());
            }
        }
    }
}

