/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.fao.fi.fishstat.data.common.api.JdbcResourceManager;

public class ClassLoaderFactory {
    private static ClassLoader loader;

    public static ClassLoader getClassLoader() {
        if (loader == null) {
            ClassLoaderFactory.setClassLoader(JdbcResourceManager.getJdbcDaoJarUrl());
        }
        return loader;
    }

    public static void dispose() {
        try {
            ((JdbcClassLoader)loader).dispose();
        }
        catch (Throwable throwable) {}
        loader = null;
    }

    public static void setClassLoader(String jdbcDaoJARpath) {
        try {
            URL jdbc_dao_url = new URL(jdbcDaoJARpath);
            URL[] urls = new URL[]{jdbc_dao_url};
            System.out.println("loading jar: " + jdbc_dao_url);
            loader = JdbcClassLoader.newInstance(urls, ClassLoaderFactory.class.getClassLoader());
            System.out.println("JDBC-DAO classloader: " + loader.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class JdbcClassLoader
    extends URLClassLoader {
        public static JdbcClassLoader newInstance(final URL[] urls) {
            JdbcClassLoader result = AccessController.doPrivileged(new PrivilegedAction<JdbcClassLoader>(){

                @Override
                public JdbcClassLoader run() {
                    return new JdbcClassLoader(urls);
                }
            });
            return result;
        }

        public static JdbcClassLoader newInstance(final URL[] urls, final ClassLoader parent) {
            JdbcClassLoader result = AccessController.doPrivileged(new PrivilegedAction<JdbcClassLoader>(){

                @Override
                public JdbcClassLoader run() {
                    return new JdbcClassLoader(urls, parent);
                }
            });
            return result;
        }

        public JdbcClassLoader(URL[] urls) {
            super(urls);
        }

        public JdbcClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> result = null;
            if (!name.startsWith("org.fao.fi.fishstat.data.generated.")) {
                result = super.loadClass(name, true);
            } else {
                result = this.findLoadedClass(name);
                if (result == null) {
                    result = this.findClass(name);
                    this.resolveClass(result);
                }
            }
            return result;
        }

        public void dispose() throws IOException {
            super.close();
        }
    }
}

