/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.building;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.settings.building.SettingsProblem;

public class SettingsBuildingException
extends Exception {
    private final List<SettingsProblem> problems = new ArrayList<SettingsProblem>();

    public SettingsBuildingException(List<SettingsProblem> problems) {
        super(SettingsBuildingException.toMessage(problems));
        if (problems != null) {
            this.problems.addAll(problems);
        }
    }

    public List<SettingsProblem> getProblems() {
        return this.problems;
    }

    private static String toMessage(List<SettingsProblem> problems) {
        StringWriter buffer = new StringWriter(1024);
        PrintWriter writer = new PrintWriter(buffer);
        writer.print(problems.size());
        writer.print(problems.size() == 1 ? " problem was " : " problems were ");
        writer.print("encountered while building the effective settings");
        writer.println();
        for (SettingsProblem problem : problems) {
            writer.print("[");
            writer.print((Object)problem.getSeverity());
            writer.print("] ");
            writer.print(problem.getMessage());
            writer.print(" @ ");
            writer.println(problem.getLocation());
        }
        return buffer.toString();
    }
}

