/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.metadata.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.archetype.metadata.AbstractArchetypeDescriptor;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.FileSet;
import org.apache.maven.archetype.metadata.ModuleDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ArchetypeDescriptorXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public ArchetypeDescriptorXpp3Reader() {
        this(new ContentTransformer(){

            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public ArchetypeDescriptorXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public ArchetypeDescriptor read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public ArchetypeDescriptor read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public ArchetypeDescriptor read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public ArchetypeDescriptor read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private AbstractArchetypeDescriptor parseAbstractArchetypeDescriptor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        AbstractArchetypeDescriptor abstractArchetypeDescriptor = new AbstractArchetypeDescriptor();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                abstractArchetypeDescriptor.setFileSets(fileSets);
                while (parser.nextTag() == 2) {
                    if ("fileSet".equals(parser.getName())) {
                        fileSets.add(this.parseFileSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
                abstractArchetypeDescriptor.setModules(modules);
                while (parser.nextTag() == 2) {
                    if ("module".equals(parser.getName())) {
                        modules.add(this.parseModuleDescriptor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return abstractArchetypeDescriptor;
    }

    private ArchetypeDescriptor parseArchetypeDescriptor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ArchetypeDescriptor archetypeDescriptor = new ArchetypeDescriptor();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            if ("name".equals(name)) {
                archetypeDescriptor.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("partial".equals(name)) {
                archetypeDescriptor.setPartial(this.getBooleanValue(this.interpolatedTrimmed(value, "partial"), "partial", parser, "false"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "requiredProperties", null, parsed)) {
                ArrayList<RequiredProperty> requiredProperties = new ArrayList<RequiredProperty>();
                archetypeDescriptor.setRequiredProperties(requiredProperties);
                while (parser.nextTag() == 2) {
                    if ("requiredProperty".equals(parser.getName())) {
                        requiredProperties.add(this.parseRequiredProperty(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                archetypeDescriptor.setFileSets(fileSets);
                while (parser.nextTag() == 2) {
                    if ("fileSet".equals(parser.getName())) {
                        fileSets.add(this.parseFileSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
                archetypeDescriptor.setModules(modules);
                while (parser.nextTag() == 2) {
                    if ("module".equals(parser.getName())) {
                        modules.add(this.parseModuleDescriptor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return archetypeDescriptor;
    }

    private FileSet parseFileSet(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        FileSet fileSet = new FileSet();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("filtered".equals(name)) {
                fileSet.setFiltered(this.getBooleanValue(this.interpolatedTrimmed(value, "filtered"), "filtered", parser, "false"));
                continue;
            }
            if ("packaged".equals(name)) {
                fileSet.setPackaged(this.getBooleanValue(this.interpolatedTrimmed(value, "packaged"), "packaged", parser, "false"));
                continue;
            }
            if ("encoding".equals(name)) {
                fileSet.setEncoding(this.interpolatedTrimmed(value, "encoding"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "directory", null, parsed)) {
                fileSet.setDirectory(this.interpolatedTrimmed(parser.nextText(), "directory"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "includes", null, parsed)) {
                ArrayList<String> includes = new ArrayList<String>();
                fileSet.setIncludes(includes);
                while (parser.nextTag() == 2) {
                    if ("include".equals(parser.getName())) {
                        includes.add(this.interpolatedTrimmed(parser.nextText(), "includes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "excludes", null, parsed)) {
                ArrayList<String> excludes = new ArrayList<String>();
                fileSet.setExcludes(excludes);
                while (parser.nextTag() == 2) {
                    if ("exclude".equals(parser.getName())) {
                        excludes.add(this.interpolatedTrimmed(parser.nextText(), "excludes"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return fileSet;
    }

    private ModuleDescriptor parseModuleDescriptor(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ModuleDescriptor moduleDescriptor = new ModuleDescriptor();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("id".equals(name)) {
                moduleDescriptor.setId(this.interpolatedTrimmed(value, "id"));
                continue;
            }
            if ("dir".equals(name)) {
                moduleDescriptor.setDir(this.interpolatedTrimmed(value, "dir"));
                continue;
            }
            if ("name".equals(name)) {
                moduleDescriptor.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "fileSets", null, parsed)) {
                ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
                moduleDescriptor.setFileSets(fileSets);
                while (parser.nextTag() == 2) {
                    if ("fileSet".equals(parser.getName())) {
                        fileSets.add(this.parseFileSet(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "modules", null, parsed)) {
                ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
                moduleDescriptor.setModules(modules);
                while (parser.nextTag() == 2) {
                    if ("module".equals(parser.getName())) {
                        modules.add(this.parseModuleDescriptor(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return moduleDescriptor;
    }

    private RequiredProperty parseRequiredProperty(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        RequiredProperty requiredProperty = new RequiredProperty();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("key".equals(name)) {
                requiredProperty.setKey(this.interpolatedTrimmed(value, "key"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "defaultValue", null, parsed)) {
                requiredProperty.setDefaultValue(this.interpolatedTrimmed(parser.nextText(), "defaultValue"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return requiredProperty;
    }

    private ArchetypeDescriptor read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"archetype-descriptor".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'archetype-descriptor' but found '" + parser.getName() + "'", parser, null);
                }
                ArchetypeDescriptor archetypeDescriptor = this.parseArchetypeDescriptor(parser, strict);
                archetypeDescriptor.setModelEncoding(parser.getInputEncoding());
                return archetypeDescriptor;
            }
            eventType = parser.next();
        }
        throw new XmlPullParserException("Expected root element 'archetype-descriptor' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

