/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.launch;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipFile;
import org.apache.maven.cli.MavenCli;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.internal.Bundles;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenEmbeddedRuntime
extends AbstractMavenRuntime {
    private static final String MAVEN_CORE_POM_PROPERTIES = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    private static final Logger log = LoggerFactory.getLogger(MavenEmbeddedRuntime.class);
    private static final String MAVEN_EMBEDDER_BUNDLE_SYMBOLICNAME = "org.eclipse.m2e.maven.runtime";
    private static final String MAVEN_EXECUTOR_CLASS = MavenCli.class.getName();
    public static final String PLEXUS_CLASSWORLD_NAME = "plexus.core";
    private static String[] LAUNCHER_CLASSPATH;
    private static String[] CLASSPATH;
    private static volatile String mavenVersion;
    private static final Bundle m2eCore;

    static {
        m2eCore = MavenPluginActivator.getDefault().getBundle();
    }

    public MavenEmbeddedRuntime() {
        super("EMBEDDED");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getLocation() {
        return "EMBEDDED";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void createLauncherConfiguration(IMavenLauncherConfiguration collector, IProgressMonitor monitor) throws CoreException {
        String entry;
        collector.setMainType(MAVEN_EXECUTOR_CLASS, PLEXUS_CLASSWORLD_NAME);
        this.initClasspath(this.findMavenEmbedderBundle());
        collector.addRealm("]launcher");
        String[] stringArray = LAUNCHER_CLASSPATH;
        int n = LAUNCHER_CLASSPATH.length;
        int n2 = 0;
        while (n2 < n) {
            entry = stringArray[n2];
            collector.addArchiveEntry(entry);
            ++n2;
        }
        collector.addRealm(PLEXUS_CLASSWORLD_NAME);
        this.collectExtensions(collector, monitor);
        stringArray = CLASSPATH;
        n = CLASSPATH.length;
        n2 = 0;
        while (n2 < n) {
            entry = stringArray[n2];
            if (!entry.contains("plexus-build-api")) {
                collector.addArchiveEntry(entry);
            }
            ++n2;
        }
    }

    private synchronized void initClasspath(Bundle mavenRuntimeBundle) {
        if (CLASSPATH == null) {
            LinkedHashSet<String> allentries = new LinkedHashSet<String>();
            this.addBundleClasspathEntries(allentries, mavenRuntimeBundle);
            String[] stringArray = new String[]{"org.slf4j.api", "org.eclipse.m2e.maven.runtime.slf4j.simple", "javax.inject"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String sname = stringArray[n2];
                Bundle dependency = Bundles.findDependencyBundle(mavenRuntimeBundle, sname);
                if (dependency != null) {
                    this.addBundleClasspathEntries(allentries, dependency);
                } else {
                    log.warn("Could not find OSGi bundle with symbolic name ''{}'' required to launch embedded maven runtime in external process", (Object)sname);
                }
                ++n2;
            }
            ArrayList<String> cp = new ArrayList<String>();
            ArrayList<String> lcp = new ArrayList<String>();
            for (String entry : allentries) {
                if (entry.contains("plexus-classworlds")) {
                    lcp.add(entry);
                    continue;
                }
                cp.add(entry);
            }
            CLASSPATH = cp.toArray(new String[cp.size()]);
            LAUNCHER_CLASSPATH = lcp.toArray(new String[lcp.size()]);
        }
    }

    private void addBundleClasspathEntries(Set<String> entries, Bundle bundle) {
        entries.addAll(Bundles.getClasspathEntries(bundle));
    }

    private Bundle findMavenEmbedderBundle() {
        return Bundles.findDependencyBundle(m2eCore, MAVEN_EMBEDDER_BUNDLE_SYMBOLICNAME);
    }

    public String toString() {
        Bundle embedder = this.findMavenEmbedderBundle();
        if (embedder != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getVersion(embedder));
            String version = (String)embedder.getHeaders().get("Bundle-Version");
            sb.append('/').append(version);
            return sb.toString();
        }
        return MAVEN_EMBEDDER_BUNDLE_SYMBOLICNAME;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized String getVersion(Bundle bundle) {
        if (MavenEmbeddedRuntime.mavenVersion != null) {
            return MavenEmbeddedRuntime.mavenVersion;
        }
        this.initClasspath(bundle);
        try {
            mavenCoreJarPath = null;
            var6_4 = MavenEmbeddedRuntime.CLASSPATH;
            var5_6 = MavenEmbeddedRuntime.CLASSPATH.length;
            var4_10 = 0;
            while (var4_10 < var5_6) {
                path = var6_4[var4_10];
                if (path.contains("maven-core")) {
                    mavenCoreJarPath = path;
                    break;
                }
                ++var4_10;
            }
            if (mavenCoreJarPath == null) {
                throw new RuntimeException("Could not find maven core jar file");
            }
            pomProperties = new Properties();
            mavenCoreJar = new File(mavenCoreJarPath);
            if (mavenCoreJar.isFile()) {
                zip = new ZipFile(mavenCoreJarPath);
                try {
                    zipEntry = zip.getEntry("META-INF/maven/org.apache.maven/maven-core/pom.properties");
                    if (zipEntry == null) ** GOTO lbl38
                    pomProperties.load(zip.getInputStream(zipEntry));
                }
                finally {
                    zip.close();
                }
            } else if (mavenCoreJar.isDirectory()) {
                is = new BufferedInputStream(new FileInputStream(new File(mavenCoreJar, "META-INF/maven/org.apache.maven/maven-core/pom.properties")));
                try {
                    pomProperties.load(is);
                }
                finally {
                    IOUtil.close((InputStream)is);
                }
            }
            if ((version = pomProperties.getProperty("version")) != null) {
                MavenEmbeddedRuntime.mavenVersion = version;
                return MavenEmbeddedRuntime.mavenVersion;
            }
        }
        catch (Exception e) {
            MavenEmbeddedRuntime.log.warn("Could not determine embedded maven version", (Throwable)e);
        }
        return Messages.MavenEmbeddedRuntime_unknown;
    }

    @Override
    public String getVersion() {
        Bundle bundle = this.findMavenEmbedderBundle();
        return this.getVersion(bundle);
    }
}

