/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.beans.Statement;
import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.ISourceProviderService;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.autoupdate.AutoUpdateMain;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.core.session.PersistenceFactory;
import org.fao.fi.fishstat.gui.handler.dynamics.SwitchWorkspaceState;
import org.fao.fi.fishstat.gui.views.GrandTotalsView;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class ApplicationAdvisor
implements Observer {
    private IWorkbenchPage activePage;
    private MultiTableView lastActiveMultiTableView;
    private static AutoUpdateMain autoupdate;
    private Vector<GrandTotalsView> activeTotalsViews = new Vector();

    public ApplicationAdvisor() {
        GuiCoreActivator.getDefault().getRegistry().addObserver((Observer)this);
        this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        this.addSiteListener(this.activePage);
        autoupdate = new AutoUpdateMain();
        if (autoupdate.isNewVersionAvailable() && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Activator.getLocalString("label.autoupdate.newversion.title"), (String)MessageFormat.format(Activator.getLocalString("label.autoupdate.newversion.message"), autoupdate.getVersion()))) {
            autoupdate.openWebSite();
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") != -1) {
            boolean JavaOK = false;
            Pattern patJavaVersion = Pattern.compile("^([0-9])[.]([0-9])[.]([0-9])");
            Matcher matJavaVersion = patJavaVersion.matcher(System.getProperty("java.version"));
            if (matJavaVersion.find()) {
                try {
                    if (matJavaVersion.group(2) != null && Integer.parseInt(matJavaVersion.group(2)) >= 8) {
                        JavaOK = true;
                    }
                }
                catch (Exception exception) {}
            }
            if (!JavaOK && MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"WARNING: Java Version too old", (String)("The FishStatJ requires Java8 active,\nbut is currently running with Java v" + System.getProperty("java.version")))) {
                try {
                    Runtime.getRuntime().exec(new String[]{"open", "-a", "Safari", "http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html"});
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof CoreRegistry) {
            String methodName = ((Statement)arg).getMethodName();
            Session session = (Session)((Statement)arg).getTarget();
            System.out.println("---> update() " + methodName + " session=" + session.getDataset().getAcronym());
            if (methodName.equals("new")) {
                this.newSessionView(session);
            }
            if (methodName.equals("focus")) {
                this.focusSessionView(session);
            }
            if (methodName.equals("close")) {
                this.closeSessionView(session);
            }
        }
    }

    private void newSessionView(Session session) {
        try {
            this.activePage.hideView(this.activePage.findView("org.fao.fi.fishstat.gui.display.views.emptyview"));
            this.lastActiveMultiTableView = (MultiTableView)this.activePage.showView("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + session.getUUID(), 1);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.fao.fi.fishstat.gui.display.views.recorddetails");
            if (Activator.getDefault().getPreferenceStore().getBoolean("display.series.on.right")) {
                this.lastActiveMultiTableView.showLastPeriodOnNextRefresh();
            }
            try {
                session.setShowSeriesDetails(false);
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                service.executeCommand("org.fao.fi.fishstat.gui.command.view.show.details", null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Activator.getDefault().getStatusBarController().activateContributions();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void focusSessionView(Session session) {
        IViewReference vr;
        if (session == GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus() && (vr = this.activePage.findViewReference("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + session.getUUID())) != null) {
            this.lastActiveMultiTableView = (MultiTableView)vr.getView(true);
            this.activePage.activate((IWorkbenchPart)this.lastActiveMultiTableView);
        }
        CoreCommons.getWorkspacesManager().refreshMenuHandlers();
    }

    public void closeSessionView(Session session) {
        try {
            if (this.activePage != null) {
                this.hideAllGrandTotalViews(session);
                IViewReference vr = this.activePage.findViewReference("org.fao.fi.fishstat.gui.display.views.multitable", "org.fao.fi.fishstat.gui.display.views.multitable-" + session.getUUID());
                if (vr != null) {
                    this.activePage.hideView(vr);
                }
                this.hideAllGrandTotalViews(session);
                if (GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size() == 0 && !ApplicationWorkbenchAdvisor.shuttingDown) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IViewPart detailsVr = ApplicationAdvisor.this.activePage.findView("org.fao.fi.fishstat.gui.display.views.recorddetails");
                            if (detailsVr != null && !ApplicationWorkbenchAdvisor.shuttingDown) {
                                ApplicationAdvisor.this.activePage.setPartState((IWorkbenchPartReference)ApplicationAdvisor.this.activePage.findViewReference("org.fao.fi.fishstat.gui.display.views.recorddetails"), 0);
                                ApplicationAdvisor.this.activePage.hideView(detailsVr);
                            }
                            try {
                                ApplicationAdvisor.this.activePage.showView("org.fao.fi.fishstat.gui.display.views.emptyview");
                            }
                            catch (PartInitException partInitException) {}
                        }
                    });
                }
                this.lastActiveMultiTableView = null;
                Activator.getDefault().getStatusBarController().deactivateAllContribtions();
                CoreCommons.getWorkspacesManager().refreshMenuHandlers();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IViewPart getLastActiveDoubleTableView() {
        return this.lastActiveMultiTableView;
    }

    public static AutoUpdateMain getAutoUpdate() {
        return autoupdate;
    }

    public void syncMenus() {
        WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
        boolean isWorkspaceLoaded = wsm.hasCurrentWorkspace();
        ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
        SwitchWorkspaceState commandStateService = (SwitchWorkspaceState)sourceProviderService.getSourceProvider("org.fao.fi.fishstat.gui.handler.dynamics.active");
        if (isWorkspaceLoaded) {
            commandStateService.setDisabled();
        } else if (wsm.getNumberOfWorkspaces() == 0) {
            commandStateService.setDisabled();
        } else {
            commandStateService.setEnabled();
        }
    }

    public void syncEditMenus(boolean active) {
        EvaluationContext ec = new EvaluationContext(null, (Object)new Boolean(active));
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.getCommand("org.fao.fi.fishstat.gui.command.edit.csv.copy.details").setEnabled((Object)ec);
        commandService.getCommand("org.fao.fi.fishstat.gui.command.edit.csv.save.details").setEnabled((Object)ec);
    }

    private void addSiteListener(IWorkbenchPage activePage) {
        activePage.addPartListener(new IPartListener2(){

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals("org.fao.fi.fishstat.gui.display.views.multitable")) {
                    MultiTableView multiTableView = (MultiTableView)partRef.getPart(true);
                    GuiSession session = multiTableView.getSession();
                    System.out.println("---> partVisible() " + session.getDataset().getAcronym());
                }
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                if (partRef.getId().equals("org.fao.fi.fishstat.gui.display.views.multitable")) {
                    MultiTableView multiTableView = (MultiTableView)partRef.getPart(true);
                    GuiSession session = multiTableView.getSession();
                    System.out.println("---> partActivated() " + session.getDataset().getAcronym());
                    session.setCalcGrandTotals(false);
                    ApplicationWorkbenchAdvisor.getApplicationAdvisor().hideAllGrandTotalViews((Session)session);
                    GuiCoreActivator.getDefault().getRegistry().setSessionOnFocus(session.getDescriptor());
                }
            }
        });
    }

    public void hideAllGrandTotalViews(Session session) {
        int i = 0;
        while (i < this.activeTotalsViews.size()) {
            System.out.println("hideAllGrandTotalViews().hideView " + ApplicationAdvisor.getGrandTotalSecondaryId(this.activeTotalsViews.get(i).getSession(), this.activeTotalsViews.get(i).getMeasure()));
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.activeTotalsViews.get(i));
            ++i;
        }
        this.activeTotalsViews = new Vector();
        for (Session aSession : GuiCoreActivator.getDefault().getRegistry().getOpenSessions()) {
            aSession.setCalcGrandTotals(false);
        }
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        service.refreshElements("org.fao.fi.fishstat.gui.command.view.show.grandtotals", null);
    }

    public void activateAllGrandTotalViews(Session session) {
        System.out.println("activateAllGrandTotalViews() " + session.getUUID() + " getCalcGrandTotals=" + session.getCalcGrandTotals());
        if (!session.getCalcGrandTotals()) {
            return;
        }
        try {
            GrandTotalsView grandTotalsView = null;
            if (session.hasObservedMeasureDimension()) {
                List usedMeasures = session.getObsMeasures();
                IWorkbenchPart selectedTabID = null;
                for (ReferenceObject measure : usedMeasures) {
                    String secondary_id = ApplicationAdvisor.getGrandTotalSecondaryId(session, measure);
                    System.out.println("secondary_id=" + secondary_id);
                    String grandTotalName = ((MultilingualString)measure.getAttribute(measure.getConcept().getNameAttribute())).getValue("en");
                    grandTotalsView = (GrandTotalsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.fao.fi.fishstat.gui.display.views.grandtotals", secondary_id, 1);
                    grandTotalsView.populateView();
                    grandTotalsView.loadTotals();
                    this.activeTotalsViews.add(grandTotalsView);
                    if (grandTotalName.toLowerCase().indexOf("tonnes") == -1) continue;
                    selectedTabID = grandTotalsView.getSite().getPart();
                }
                if (selectedTabID != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate(selectedTabID);
                }
            } else {
                String secondary_id = ApplicationAdvisor.getGrandTotalSecondaryId(session, null);
                System.out.println("activateAllGrandTotalViews().activePage " + secondary_id + " showView=" + session.getCalcGrandTotals());
                grandTotalsView = (GrandTotalsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.fao.fi.fishstat.gui.display.views.grandtotals", secondary_id, 1);
                grandTotalsView.populateView();
                grandTotalsView.loadTotals();
                this.activeTotalsViews.add(grandTotalsView);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getGrandTotalSecondaryId(Session session, ReferenceObject measure) {
        StringBuffer secondary_id = new StringBuffer(100);
        secondary_id.append(session.getDescriptor().getUuid());
        if (measure == null) {
            secondary_id.append("-[unique]");
        } else {
            secondary_id.append("-");
            secondary_id.append(measure.getId());
        }
        return secondary_id.toString();
    }

    public static void workspaceClose() {
        try {
            Display.getDefault().getActiveShell().setCursor(Display.getDefault().getSystemCursor(1));
            WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
            if (Activator.getDefault().getPreferenceStore().getBoolean("core.persist.work.session")) {
                try {
                    if (wsm.hasCurrentWorkspace() && PersistenceFactory.getSaveOnExit()) {
                        PersistenceFactory.persistWorkingSession();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            List openSessions = GuiCoreActivator.getDefault().getRegistry().getOpenSessions();
            for (Session activitySession : openSessions) {
                ApplicationWorkbenchAdvisor.getApplicationAdvisor().closeSessionView(activitySession);
            }
            wsm.closeCurrentWorkspace();
            Activator.getDefault().setApplicationTitlePostfix("");
            Activator.getDefault().getPreferenceStore().setValue("core.current.workspace.id", wsm.hasCurrentWorkspace() ? wsm.getCurrentWorkspace().getLocationDir().getAbsolutePath() : "");
            ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncMenus();
            Display.getDefault().getActiveShell().setCursor(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void workspaceOpen(String workspace_path) {
        try {
            WorkspacesManager wsm = CoreCommons.getWorkspacesManager();
            wsm.switchWorkspace(workspace_path);
            Activator.getDefault().setApplicationTitlePostfix(wsm.getCurrentWorkspace().getName(Activator.getLanguage()));
            if (Activator.getDefault().getPreferenceStore().getBoolean("core.persist.work.session")) {
                ApplicationWorkbenchAdvisor.getPrecedentSession();
            }
            Activator.getDefault().getPreferenceStore().setValue("core.current.workspace.id", workspace_path);
            ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncMenus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

