/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.swt.widgets.Display;
import org.fao.fi.fishstat.gui.Activator;

public class StatusBarController {
    public static final String RECORD_NUMBER = "RECORD_NUMBER";
    public static final String TOTAL_RECORDS = "TOTAL_RECORDS";
    public static final String TIME_SERIES_UNIT = "TIME_SERIES_UNIT";
    private IStatusLineManager statusLineManager = null;
    private StatusLineContributionItem recordNumberContributionItem = new StatusLineContributionItem("RECORD_NUMBER", 20);
    private StatusLineContributionItem totalRecordsContributionItem = new StatusLineContributionItem("TOTAL_RECORDS", 20);
    private StatusLineContributionItem timeSeriesUnitContributionItem = new StatusLineContributionItem("TIME_SERIES_UNIT", 25);

    public void setRecordNumber(final int number) {
        if (this.recordNumberContributionItem != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusBarController.this.recordNumberContributionItem.setText(String.valueOf(Activator.getLocalString("label.record.no.dot")) + " " + (number + 1) + " " + Activator.getLocalString("label.of.first.lower"));
                }
            });
        }
    }

    public void cleanRecordNumber() {
        if (this.recordNumberContributionItem != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusBarController.this.recordNumberContributionItem.setText("");
                }
            });
        }
    }

    public void setTotalRecords(final int total) {
        if (this.totalRecordsContributionItem != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusBarController.this.totalRecordsContributionItem.setText(String.valueOf(total) + " " + Activator.getLocalString("label.filtered.records"));
                }
            });
        }
    }

    public void setRecordNumberOf(final int recno, final int of) {
        if (this.recordNumberContributionItem != null && this.totalRecordsContributionItem != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusBarController.this.recordNumberContributionItem.setText(String.valueOf(Activator.getLocalString("label.record.no.dot")) + " " + recno + " " + Activator.getLocalString("label.of.first.lower"));
                    StatusBarController.this.totalRecordsContributionItem.setText(String.valueOf(of) + " " + Activator.getLocalString("label.filtered.records"));
                }
            });
        }
    }

    public void setUnit(final String[] unit) {
        if (this.timeSeriesUnitContributionItem != null && unit != null && unit.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    StatusBarController.this.timeSeriesUnitContributionItem.setText(unit[0] != null ? String.valueOf(Activator.getLocalString("label.unit.column")) + " " + unit[0] + StatusBarController.this.processMultiplier(unit[1]) : "");
                }
            });
        }
    }

    private String processMultiplier(String multiplier) {
        if (multiplier != null) {
            try {
                int int_multiplier = Integer.decode(multiplier);
                if (int_multiplier > 1) {
                    int pow = (int)Math.pow(10.0, int_multiplier);
                    return " x " + pow;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return "";
            }
        }
        return "";
    }

    public IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    protected void setStatusLineManager(IStatusLineManager statusLineManager) {
        this.statusLineManager = statusLineManager;
    }

    public void activateContributions() {
        if (this.statusLineManager.find(RECORD_NUMBER) == null) {
            this.statusLineManager.add((IContributionItem)this.recordNumberContributionItem);
        }
        if (this.statusLineManager.find(TOTAL_RECORDS) == null) {
            this.statusLineManager.insertAfter(RECORD_NUMBER, (IContributionItem)this.totalRecordsContributionItem);
        }
        if (this.statusLineManager.find(TIME_SERIES_UNIT) == null) {
            this.statusLineManager.insertAfter(TOTAL_RECORDS, (IContributionItem)this.timeSeriesUnitContributionItem);
        }
        this.statusLineManager.update(false);
    }

    public void deactivateAllContribtions() {
        this.statusLineManager.removeAll();
        this.statusLineManager.update(false);
    }
}

