/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.selection;

import java.util.Collection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.properties.dataset.TimeSeriesPage;
import org.fao.fi.fishstat.gui.properties.dataset.selection.DatasetSelectionComposite;

public class DatasetSelectionPage
extends TimeSeriesPage
implements IWorkbenchPropertyPage {
    public static final String SCOPE = "select";
    private DatasetSelectionComposite cmpSelection;
    private Dimension dimension;

    public DatasetSelectionPage(TimeSeriesProperties p, Dimension d) {
        super(p);
        this.properties = p;
        this.dimension = d;
        this.setTitle(Activator.getLocalString("label.selection.first.upper"));
        this.setDescription(Activator.getLocalString("label.choose.selection.dimension.attributes"));
    }

    @Override
    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.cmpSelection = new DatasetSelectionComposite(container, 0, this.properties, this.dimension.getIndex());
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        this.cmpSelection.setLayoutData(gridData);
        return container;
    }

    @Override
    protected void performApply() {
        this.applyData(null);
    }

    @Override
    public boolean performOk() {
        this.applyData(null);
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public void applyData(Object data) {
        Collection dimensionPropertiesCollection = this.properties.getDatasetProperties().getDimensionsProperties();
        for (DimensionProperties dimensionProperties : dimensionPropertiesCollection) {
            if (!dimensionProperties.hasChanged()) continue;
            dimensionProperties.notifyObservers();
        }
        super.applyData(data);
    }
}

