/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.sorting;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.DatasetProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.properties.dataset.sorting.AdvanceSorterPanel;

public class AdvanceSortDialog
extends TitleAreaDialog {
    private MultiSortProperties sortProperties;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private final AdvanceSorterPanel[] panels = new AdvanceSorterPanel[5];
    private Composite container;

    public AdvanceSortDialog(Shell parentShell, MultiSortProperties sortProperties) {
        super(parentShell);
        this.sortProperties = sortProperties;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Activator.getLocalString("label.advanced.sort"));
        this.setMessage(Activator.getLocalString("label.advanced.sort.message"));
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        Composite area = (Composite)super.createDialogArea(parent);
        this.container = new Composite(area, 0);
        this.container.setBackground(SWTResourceManager.getColor(1));
        this.container.setLayout((Layout)new GridLayout(1, false));
        this.container.setLayoutData((Object)new GridData(1808));
        int sortSize = this.sortProperties.size();
        int i = 0;
        while (i < 5) {
            MultiSortElemProperties ssp = i < sortSize ? this.sortProperties.getSorter(i) : new MultiSortElemProperties(this.sortProperties);
            this.panels[i] = new AdvanceSorterPanel(this.container, 0, ssp);
            this.panels[i].setLayoutData(new GridData(4, 4, true, false, 1, 1));
            this.formToolkit.paintBordersFor((Composite)this.panels[i]);
            ++i;
        }
        this.syncroPanel();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1024, Activator.getLocalString("label.restore.defaults"), false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.applyData();
        }
        if (buttonId == 1024) {
            this.resetSort();
        }
        super.buttonPressed(buttonId);
    }

    protected void syncroPanel() {
        int i = 0;
        while (i < 5) {
            this.panels[i].syncroPanel();
            ++i;
        }
    }

    protected void applyData() {
        int i = 0;
        while (i < this.panels.length) {
            this.panels[i].applyData();
            ++i;
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("core.join.related.series")) {
            DatasetProperties datasetProperties = this.sortProperties.getTimeSeriesProperties().getDatasetProperties();
            datasetProperties.replicateSortProperties(this.sortProperties);
            for (TimeSeriesProperties timeSeriesProperties : datasetProperties.getTimeSeriesProperties()) {
                timeSeriesProperties.getSorter().storeProperties();
            }
        } else {
            this.sortProperties.getTimeSeriesProperties().getDatasetProperties().storeProperties();
        }
    }

    protected void resetSort() {
        this.sortProperties.createDefaultSorter();
        int i = 0;
        while (i < 5) {
            MultiSortElemProperties ep = i < this.sortProperties.size() ? this.sortProperties.getSorter(i) : new MultiSortElemProperties(this.sortProperties);
            this.panels[i].setProperties(ep);
            ++i;
        }
    }
}

