/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.GuiCommons;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.YearDateComposite;

public class GrandTotalsView
extends ViewPart
implements Observer {
    public static final String ID = "org.fao.fi.fishstat.gui.display.views.grandtotals";
    private ScrolledComposite scrolledComposite;
    private Composite parent;
    private YearDateComposite[] cells;
    private Composite panel;
    private ReferenceObject measure;
    private MenuManager menuManager;
    private GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();

    public GrandTotalsView() {
        this.session.addObserver((Observer)this);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.initializeToolBar();
        this.scrolledComposite = this.createScrolledComposite();
        this.panel = this.createPanel();
        this.measure = this.calculateMeasureObject();
        this.menuManager = new MenuManager();
        this.getSite().registerContextMenu(this.menuManager, null);
        this.menuManager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void populateView() {
        if (this.measure != null) {
            StringBuffer partName = new StringBuffer(30);
            partName.append(GuiCommons.getLocalizedValue(this.session.getDataset().getName()));
            partName.append(" - ");
            partName.append(GuiCommons.getLocalizedValue(this.measure.getAttribute(this.measure.getConcept().getNameAttribute())));
            this.setPartName(partName.toString());
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!GrandTotalsView.this.panel.isDisposed() && !GrandTotalsView.this.scrolledComposite.isDisposed()) {
                    GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
                    GrandTotalsView.this.removeCells();
                    if (session != null) {
                        TimeSeriesProperties properties = session.getTimeseriesProperties();
                        GrandTotalsView.this.cells = new YearDateComposite[properties.getPeriodsSize()];
                        int i = 0;
                        while (i < GrandTotalsView.this.cells.length) {
                            Control[] controls;
                            ((GrandTotalsView)GrandTotalsView.this).cells[i] = new YearDateComposite(GrandTotalsView.this.panel, 0, properties.getPeriod(i).getISO8601(), null, true);
                            Control[] controlArray = controls = GrandTotalsView.this.cells[i].getChildren();
                            int n = controls.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control control = controlArray[n2];
                                Menu menu1 = GrandTotalsView.this.menuManager.createContextMenu(control);
                                control.setMenu(menu1);
                                ++n2;
                            }
                            ++i;
                        }
                    }
                    GrandTotalsView.this.scrolledComposite.layout();
                    GrandTotalsView.this.panel.layout();
                }
            }
        });
    }

    private void removeCells() {
        if (this.cells != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < GrandTotalsView.this.cells.length) {
                        if (GrandTotalsView.this.cells[i] != null && !GrandTotalsView.this.cells[i].isDisposed()) {
                            GrandTotalsView.this.cells[i].dispose();
                        }
                        ++i;
                    }
                    GrandTotalsView.this.panel.layout();
                }
            });
        }
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    public void loadTotals() {
        if (this.session == null) {
            return;
        }
        if (!this.scrolledComposite.isDisposed()) {
            if (this.panel.isDisposed()) {
                this.panel = this.createPanel();
                System.out.println("GrandTotalsView().loadTotals() createPanel");
            }
            if (this.cells == null || this.cells.length > 0 && this.cells[0].isDisposed()) {
                this.populateView();
            }
            final TimeSeriesProperties properties = this.session.getTimeseriesProperties();
            final ObservationSeries totals = this.session.getGrandTotals(this.measure);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    GrandTotalsView.this.removeCells();
                    GrandTotalsView.this.cells = new YearDateComposite[properties.getPeriodsSize()];
                    int i = 0;
                    while (i < GrandTotalsView.this.cells.length) {
                        Control[] controls;
                        ((GrandTotalsView)GrandTotalsView.this).cells[i] = new YearDateComposite(GrandTotalsView.this.panel, 0, properties.getPeriod(i).getISO8601(), null, true);
                        Control[] controlArray = controls = GrandTotalsView.this.cells[i].getChildren();
                        int n = controls.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Control control = controlArray[n2];
                            Menu menu1 = GrandTotalsView.this.menuManager.createContextMenu(control);
                            control.setMenu(menu1);
                            ++n2;
                        }
                        ++i;
                    }
                    GrandTotalsView.this.scrolledComposite.layout();
                    GrandTotalsView.this.panel.layout();
                    try {
                        i = 0;
                        while (i < properties.getPeriodsSize()) {
                            Measure m = totals.getMeasure(properties.getPeriod(i));
                            GrandTotalsView.this.cells[i].setMeasure(m);
                            ++i;
                        }
                    }
                    catch (TimeseriesServiceException timeseriesServiceException) {}
                }
            });
        }
    }

    public ReferenceObject getMeasure() {
        return this.measure;
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Session) {
            this.populateView();
            this.loadTotals();
        }
    }

    public void dispose() {
        this.session.setCalcGrandTotals(false);
        ApplicationWorkbenchAdvisor.getApplicationAdvisor().hideAllGrandTotalViews((Session)this.session);
    }

    private ReferenceObject calculateMeasureObject() {
        if (this.session.hasObservedMeasureDimension()) {
            String secondary_id = this.getViewSite().getSecondaryId();
            String[] parts = secondary_id.split("-");
            return this.session.getObservedMeasureDimension().getConcept().getObject(IdentifierFactory.instance((String)parts[parts.length - 1]));
        }
        return null;
    }

    private ScrolledComposite createScrolledComposite() {
        final ScrolledComposite res = new ScrolledComposite(this.parent, 512);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                res.setAlwaysShowScrollBars(false);
                res.setMinSize(400, 100);
                res.setExpandHorizontal(true);
                res.setExpandVertical(true);
            }
        });
        return res;
    }

    private Composite createPanel() {
        Composite res = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)res);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 4;
        rowLayout.marginRight = 10;
        rowLayout.marginLeft = 10;
        rowLayout.marginBottom = 10;
        rowLayout.marginTop = 10;
        res.setLayout((Layout)rowLayout);
        return res;
    }
}

