/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Application;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.YearDateComposite;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class RecordDetailsView
extends ViewPart
implements ISelectionListener,
Observer {
    private ScrolledComposite scrolledComposite;
    private GuiSession session;
    public static final String ID = "org.fao.fi.fishstat.gui.display.views.recorddetails";
    private Composite parent;
    private YearDateComposite[] cells;
    private Composite panel;

    public void createPartControl(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.initializeToolBar();
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.panel = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.panel);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.spacing = 4;
        rowLayout.marginRight = 10;
        rowLayout.marginLeft = 10;
        rowLayout.marginBottom = 10;
        rowLayout.marginTop = 10;
        this.panel.setLayout((Layout)rowLayout);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
    }

    public void populateView() {
        if (!this.panel.isDisposed() && !this.scrolledComposite.isDisposed()) {
            this.session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
            this.session.addObserver((Observer)this);
            if (this.session != null) {
                final TimeSeriesProperties properties = this.session.getTimeseriesProperties();
                Application.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        RecordDetailsView.this.removeCells();
                        RecordDetailsView.this.scrolledComposite.setMinSize(400, properties.getPeriodsSize() * 2 + 20);
                        RecordDetailsView.this.cells = new YearDateComposite[properties.getPeriodsSize()];
                        int i = 0;
                        while (i < RecordDetailsView.this.cells.length) {
                            ((RecordDetailsView)RecordDetailsView.this).cells[i] = new YearDateComposite(RecordDetailsView.this.panel, 0, properties.getPeriod(i).getISO8601(), null, true);
                            ++i;
                        }
                        RecordDetailsView.this.scrolledComposite.layout();
                        RecordDetailsView.this.panel.layout();
                    }
                });
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.populateView();
    }

    private void removeCells() {
        if (this.cells != null) {
            int i = 0;
            while (i < this.cells.length) {
                if (this.cells[i] != null && !this.cells[i].isDisposed()) {
                    this.cells[i].dispose();
                }
                ++i;
            }
        }
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof MultiTableView && this.cells != null) {
            try {
                TimeSeriesProperties properties = ((MultiTableView)part).getSession().getTimeseriesProperties();
                ObservationSeries record = (ObservationSeries)((IStructuredSelection)selection).getFirstElement();
                if (record == null) {
                    if (((MultiTableView)part).getSession().getShowSeriesDetails()) {
                        int i = 0;
                        while (i < this.cells.length) {
                            if (!this.cells[i].isDisposed()) {
                                this.cells[i].setMeasure(null);
                            }
                            ++i;
                        }
                    }
                } else {
                    Map measures = record.getMeasures();
                    int i = 0;
                    while (i < this.cells.length) {
                        Measure m;
                        Measure measure = m = properties.hasPeriod(i) ? (Measure)measures.get(properties.getPeriod(i)) : null;
                        if (measures != null && !this.cells[i].isDisposed()) {
                            this.cells[i].setMeasure(m);
                        }
                        ++i;
                    }
                }
            }
            catch (TimeseriesServiceException e) {
                e.printStackTrace();
            }
        }
    }
}

